/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.thrift.transport;

import com.databricks.client.jdbc42.internal.apache.thrift.TByteArrayOutputStream;
import com.databricks.client.jdbc42.internal.apache.thrift.TConfiguration;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TEndpointTransport;
import com.databricks.client.jdbc42.internal.apache.thrift.transport.TTransportException;
import java.nio.ByteBuffer;

public class TMemoryTransport
extends TEndpointTransport {
    private final ByteBuffer inputBuffer;
    private final TByteArrayOutputStream outputBuffer;

    public TMemoryTransport(byte[] input) throws TTransportException {
        super(new TConfiguration());
        this.inputBuffer = ByteBuffer.wrap(input);
        this.outputBuffer = new TByteArrayOutputStream(1024);
        this.updateKnownMessageSize(input.length);
    }

    public TMemoryTransport(TConfiguration config, byte[] input) throws TTransportException {
        super(config);
        this.inputBuffer = ByteBuffer.wrap(input);
        this.outputBuffer = new TByteArrayOutputStream(1024);
        this.updateKnownMessageSize(input.length);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        this.checkReadBytesAvailable(len);
        int remaining = this.inputBuffer.remaining();
        if (remaining < len) {
            throw new TTransportException(4, "There's only " + remaining + "bytes, but it asks for " + len);
        }
        this.inputBuffer.get(buf, off, len);
        return len;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        this.outputBuffer.write(buf, off, len);
    }

    public TByteArrayOutputStream getOutput() {
        return this.outputBuffer;
    }
}

