/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.logging.log4j.core.util.internal;

import com.databricks.client.jdbc42.internal.apache.logging.log4j.core.Logger;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.message.MessageFactory;
import com.databricks.client.jdbc42.internal.apache.logging.log4j.status.StatusLogger;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class InternalLoggerRegistry {
    private final Map<MessageFactory, Map<String, WeakReference<Logger>>> loggerRefByNameByMessageFactory = new WeakHashMap<MessageFactory, Map<String, WeakReference<Logger>>>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Logger getLogger(String name, MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactory, "messageFactory");
        this.readLock.lock();
        try {
            Logger logger = Optional.of(this.loggerRefByNameByMessageFactory).map(loggerRefByNameByMessageFactory -> (Map)loggerRefByNameByMessageFactory.get(messageFactory)).map(loggerRefByName -> (WeakReference)loggerRefByName.get(name)).map(Reference::get).orElse(null);
            return logger;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<Logger> getLoggers() {
        this.readLock.lock();
        try {
            Collection collection = this.loggerRefByNameByMessageFactory.values().stream().flatMap(loggerRefByName -> loggerRefByName.values().stream()).flatMap(loggerRef -> {
                @Nullable Logger logger = (Logger)loggerRef.get();
                return logger != null ? Stream.of(logger) : Stream.empty();
            }).collect(Collectors.toList());
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasLogger(String name, MessageFactory messageFactory) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactory, "messageFactory");
        return this.getLogger(name, messageFactory) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactoryClass, "messageFactoryClass");
        this.readLock.lock();
        try {
            boolean bl = this.loggerRefByNameByMessageFactory.entrySet().stream().filter(entry -> messageFactoryClass.equals(((MessageFactory)entry.getKey()).getClass())).anyMatch(entry -> ((Map)entry.getValue()).containsKey(name));
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger computeIfAbsent(String name, MessageFactory messageFactory, BiFunction<String, MessageFactory, Logger> loggerSupplier) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(messageFactory, "messageFactory");
        Objects.requireNonNull(loggerSupplier, "loggerSupplier");
        @Nullable Logger logger = this.getLogger(name, messageFactory);
        if (logger != null) {
            return logger;
        }
        this.writeLock.lock();
        try {
            Map loggerRefByName = this.loggerRefByNameByMessageFactory.computeIfAbsent(messageFactory, ignored -> new HashMap());
            WeakReference loggerRef = (WeakReference)loggerRefByName.get(name);
            if (loggerRef != null && (logger = (Logger)loggerRef.get()) != null) {
                Logger logger2 = logger;
                return logger2;
            }
            logger = loggerSupplier.apply(name, messageFactory);
            String loggerName = logger.getName();
            Object loggerMessageFactory = logger.getMessageFactory();
            if (!loggerMessageFactory.equals(messageFactory)) {
                StatusLogger.getLogger().error("Newly registered logger with name `{}` and message factory `{}`, is requested to be associated with a different name `{}` or message factory `{}`.\nEffectively the message factory of the logger will be used and the other one will be ignored.\nThis generally hints a problem at the logger context implementation.\nPlease report this using the Log4j project issue tracker.", (Object)loggerName, loggerMessageFactory, (Object)name, (Object)messageFactory);
                this.loggerRefByNameByMessageFactory.computeIfAbsent((MessageFactory)loggerMessageFactory, (Function<MessageFactory, Map<String, WeakReference<Logger>>>)((Function<MessageFactory, Map>)ignored -> new HashMap())).putIfAbsent(loggerName, new WeakReference<Logger>(logger));
            }
            loggerRefByName.put(name, new WeakReference<Logger>(logger));
            Logger logger3 = logger;
            return logger3;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

