/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc41.future;

import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.future.SCallableStatement;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.utilities.JDBCVersion;
import java.sql.SQLException;

public class S41CallableStatement
extends SCallableStatement {
    public S41CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(string, iStatement, sConnection, n, JDBCVersion.JDBC41);
    }

    protected S41CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = jDBCVersion;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntranceOneLongOneObj(this.m_logger, n, clazz);
        Object t = s_objectGetterWithClass.get(this, n, clazz);
        assert (t == null || clazz.isInstance(t));
        return t;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, clazz);
        return this.getObject(this.getParameterIndex(string), clazz);
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

