/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.common;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.core.interfaces.IDriver;
import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.dsi.dataengine.impl.DSIEmptyResultSet;
import com.databricks.client.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.databricks.client.dsi.dataengine.interfaces.IErrorResult;
import com.databricks.client.dsi.dataengine.interfaces.IRowCountResult;
import com.databricks.client.dsi.dataengine.interfaces.future.IResultSet;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResult;
import com.databricks.client.dsi.dataengine.utilities.ExecutionResultType;
import com.databricks.client.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.exceptions.JDBCMessageKey;
import com.databricks.client.jdbc.common.BaseForwardResultSet;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.SWarningListener;
import com.databricks.client.jdbc.common.utilities.WrapperUtilities;
import com.databricks.client.jdbc.interfaces.IJDBCObjectFactory;
import com.databricks.client.jdbc.interfaces.IJDBCStatement;
import com.databricks.client.jdbc.interfaces.IResultSetParent;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IMessageSource;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.Pair;
import com.databricks.client.support.exceptions.ErrorException;
import com.databricks.client.support.exceptions.ExceptionType;
import com.databricks.client.utilities.FunctionID;
import com.databricks.client.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public abstract class BaseStatement<R extends IResultSet>
implements IJDBCStatement,
IResultSetParent {
    private static final String INSERT_TOKEN = "insert";
    private static final int RESULT_SET_UPDATE_COUNT = -1;
    private final SConnection m_parentConn;
    protected ParameterGeneratedValues m_generatedParams = null;
    protected IResultSet m_generatedResult = DSIEmptyResultSet.INSTANCE;
    protected IStatement m_statement = null;
    protected SWarningListener m_warningListener = null;
    protected IMessageSource m_messageSource = null;
    protected boolean m_escapeProcessingEnabled = true;
    protected ILogger m_logger = null;
    private int m_currentResultSetIndex = 0;
    private int m_concurrency = 1007;
    private List<String> m_batchSQLStatements = new ArrayList<String>();
    protected JDBCVersion m_jdbcVersion;
    private final Object m_closeLock = new Object();
    protected boolean m_isCanceled = false;
    protected boolean m_isInCancelableFunction = false;
    protected final Object m_cancelLock = new Object();
    private final Object m_resultSetsLock = new Object();
    protected volatile boolean m_closeOnCompletion = false;
    protected final long m_stateMachineMode;

    protected static boolean isInsertStatement(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        return INSERT_TOKEN.equalsIgnoreCase(string2);
    }

    protected static BaseThrowCondition GetThrowCondition(long l, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5;
        long l2 = bl ? 4L : 2L;
        boolean bl6 = bl5 = bl3 && l2 != (l & l2);
        boolean bl7 = bl2 ? true : (bl4 = 1L != (l & 1L));
        if (bl4) {
            if (bl) {
                return bl5 ? BaseThrowCondition.SingleResult : BaseThrowCondition.FirstResult;
            }
            return bl5 ? BaseThrowCondition.SingleRowCount : BaseThrowCondition.FirstRowCount;
        }
        assert (!bl5);
        return BaseThrowCondition.None;
    }

    protected static BaseThrowCondition GetThrowConditionForAfterPrepare(long l, boolean bl) {
        return BaseStatement.GetThrowCondition(l, bl, false, false);
    }

    protected static BaseThrowCondition GetThrowConditionForAfterExecute(long l, boolean bl) {
        return BaseStatement.GetThrowCondition(l, bl, true, true);
    }

    private static int longUpdateCountToInt(long l) {
        if (l == -3L) {
            return -3;
        }
        if (l == -2L || l > Integer.MAX_VALUE) {
            return -2;
        }
        if (l < 0L) {
            throw new IllegalArgumentException(String.format("Invalid updateCount: %d", l));
        }
        return (int)l;
    }

    private static int[] longUpdateCountstoInts(long[] lArray) {
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = BaseStatement.longUpdateCountToInt(lArray[i]);
        }
        return nArray;
    }

    protected static BatchUpdateException largeBatchException(List<SQLException> list, long[] lArray) {
        return BaseStatement.createBatchUpdateException(list, BaseStatement.longUpdateCountstoInts(lArray));
    }

    private static BatchUpdateException createBatchUpdateException(List<SQLException> list, int[] nArray) {
        BatchUpdateException batchUpdateException = null;
        if (null != list && !list.isEmpty()) {
            Iterator<SQLException> iterator = list.iterator();
            SQLException sQLException = iterator.next();
            SQLException sQLException2 = batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray);
            while (iterator.hasNext()) {
                SQLException sQLException3 = iterator.next();
                sQLException2.setNextException(sQLException3);
                sQLException2 = sQLException3;
            }
        }
        return batchUpdateException;
    }

    protected BaseStatement(SConnection sConnection, IStatement iStatement, int n) throws SQLException {
        this.m_parentConn = sConnection;
        this.m_logger = iStatement.getLog();
        LogUtilities.logFunctionEntrance(this.m_logger, iStatement, n);
        this.m_statement = iStatement;
        this.m_concurrency = n;
        this.m_messageSource = DSIDriverSingleton.getInstance().getMessageSource();
        this.m_warningListener = new SWarningListener(this.m_messageSource, null);
        this.m_warningListener.setLocale(this.m_statement.getParentConnection().getLocale());
        this.m_statement.registerWarningListener(this.m_warningListener);
        try {
            this.m_stateMachineMode = DSIDriverSingleton.getInstance().getProperty(36).getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.m_batchSQLStatements.add(this.doSqlNativeSqlIfNeeded(string));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                if (this.m_isInCancelableFunction) {
                    this.m_isCanceled = true;
                }
            }
            this.doCancel();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected abstract void doCancel() throws ErrorException;

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_batchSQLStatements.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            if (null != this.m_statement) {
                this.clearResults();
                this.getParentConnection().removeStatement(this);
                this.doClose();
                try {
                    this.m_statement.close();
                }
                catch (Exception exception) {
                    throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
                }
                finally {
                    this.m_statement = null;
                    this.m_generatedResult = null;
                }
            }
        }
    }

    protected abstract void doClose();

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            this.executeNoParams(string, this.m_generatedParams, BaseThrowCondition.None);
            if (!this.hasNextResult()) {
                return false;
            }
            ExecutionResult executionResult = this.checkAndMoveToNextResult(string, BaseThrowCondition.None);
            this.throwIfErrorResult(executionResult, true);
            return ExecutionResultType.RESULT_SET == executionResult.getType() || ExecutionResultType.ERROR_RESULT_SET == executionResult.getType();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected abstract List<? extends BaseResultContext> getResultsets();

    protected abstract boolean hasNextResult();

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n != 1 && n != 2) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
            }
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(n);
            } else if (n == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.execute(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(nArray);
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                this.m_generatedParams = new ParameterGeneratedValues(stringArray);
                return this.execute(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processBatchResults(this.getResultsIterator(), Collections.emptyList(), BaseBatchType.MULTI_STATEMENT);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected abstract Iterator<ExecutionResult> getResultsIterator() throws ErrorException;

    protected abstract void executeAnyBatch() throws SQLException, BatchUpdateException;

    private ResultSet completeResultSetInitializationIfNeeded(ResultSet resultSet) throws SQLException {
        if (resultSet instanceof BaseForwardResultSet) {
            ((BaseForwardResultSet)resultSet).initializeColumnNameMap();
        }
        return resultSet;
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            this.executeNoParams(string, null, BaseThrowCondition.None);
            ExecutionResult executionResult = this.checkAndMoveToNextResult(string, BaseStatement.GetThrowConditionForAfterExecute(this.m_stateMachineMode, true));
            this.throwIfErrorResult(executionResult, false);
            assert (executionResult.getType() == ExecutionResultType.RESULT_SET);
            return this.getResultSet();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            return this.castRowCount(this.executeAnyUpdate(string));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected synchronized long executeAnyUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            this.checkIfNullSQL(string);
            if (!this.m_batchSQLStatements.isEmpty()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.clearResults();
            this.executeNoParams(string, this.m_generatedParams, BaseThrowCondition.None);
            ExecutionResult executionResult = this.checkAndMoveToNextResult(string, BaseStatement.GetThrowConditionForAfterExecute(this.m_stateMachineMode, false));
            this.throwIfErrorResult(executionResult, false);
            assert (executionResult.getType() == ExecutionResultType.ROW_COUNT);
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            if (iRowCountResult.hasRowCount()) {
                return iRowCountResult.getRowCount();
            }
            return 0L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            boolean bl = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (bl) {
                if (n != 1 && n != 2) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_OBJECT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, new Object[0]);
                }
                this.m_generatedParams = new ParameterGeneratedValues(n);
            }
            if (!bl && n == 1) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.executeUpdate(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            boolean bl = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (bl) {
                this.m_generatedParams = new ParameterGeneratedValues(nArray);
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            boolean bl = this.getConnection().getMetaData().supportsGetGeneratedKeys();
            if (bl) {
                this.m_generatedParams = new ParameterGeneratedValues(stringArray);
                return this.executeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized Object getAttribute(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            Variant variant = this.m_statement.getCustomProperty(n);
            switch (variant.getType()) {
                case 5: {
                    return variant.getShort();
                }
                case 2: {
                    return Character.valueOf(variant.getChar());
                }
                case 6: {
                    return variant.getInt();
                }
                case 3: 
                case 7: {
                    return variant.getLong();
                }
                case 4: {
                    return variant.getBigInteger();
                }
            }
            return variant.getString();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getParentConnection();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_statement.getProperty(6).getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (!this.getConnection().getMetaData().supportsGetGeneratedKeys()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            return this.completeResultSetInitializationIfNeeded(this.createResultSet(this.m_generatedResult, false, 0));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(1);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            try {
                return this.m_statement.getProperty(2).getInt();
            }
            catch (NumericOverflowException numericOverflowException) {
                return 0;
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getMoreResults(true);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1: {
                    return this.getMoreResults(true);
                }
                case 3: {
                    this.closeAllResultsToCurrent();
                    return this.getMoreResults(true);
                }
                case 2: {
                    IDriver iDriver = DSIDriverSingleton.getInstance();
                    Variant variant = iDriver.getProperty(1005);
                    if (variant.getShort() != 1) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                    }
                    return this.getMoreResults(false);
                }
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MORERESULTS_VALUE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public abstract SConnection getParentConnection();

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getStatementPropertyInt(3);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.getResultsets().size() > this.m_currentResultSetIndex) {
                BaseResultContext baseResultContext = this.getResultsets().get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_RESULT_SET == baseResultContext.m_resultType) {
                    throw ((IErrorResult)baseResultContext.m_result).getError();
                }
                if (ExecutionResultType.RESULT_SET == baseResultContext.m_resultType) {
                    return this.completeResultSetInitializationIfNeeded((ResultSet)baseResultContext.m_result);
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_concurrency;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.getParentConnection().getHoldability();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public IStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return this.castRowCount(this.getAnyUpdateCount());
    }

    public synchronized long getAnyUpdateCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.getResultsets().size() > this.m_currentResultSetIndex) {
                BaseResultContext baseResultContext = this.getResultsets().get(this.m_currentResultSetIndex);
                if (ExecutionResultType.ERROR_ROW_COUNT == baseResultContext.m_resultType) {
                    throw ((IErrorResult)baseResultContext.m_result).getError();
                }
                if (ExecutionResultType.ROW_COUNT == baseResultContext.m_resultType) {
                    return ((IRowCountResult)baseResultContext.m_result).getRowCount();
                }
            }
            return -1L;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public SWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized void setAttribute(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!this.m_statement.isCustomProperty(n)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_ATTRIBUTE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(n));
            }
            int n2 = this.m_statement.getCustomPropertyType(n);
            this.m_statement.setCustomProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCursorName(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, bl);
            this.checkIfOpen();
            this.m_escapeProcessingEnabled = bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1000: {
                    break;
                }
                case 1001: 
                case 1002: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (n < 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE_UNLIMITED_MAX, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
            }
            this.m_statement.setProperty(6, new Variant(4, n));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setMaxFieldSize(int n) throws SQLException {
        long l = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        try {
            l = this.getStatementPropertyLong(101);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(1, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FIELD_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public synchronized void setMaxRows(int n) throws SQLException {
        this.setAnyMaxRows(n);
    }

    protected synchronized void setAnyMaxRows(long l) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, l);
        this.checkIfOpen();
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(103);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l2 < 0L) {
            throw new IllegalStateException(String.format("DSI_STMT_MAX_ROWS_MIN_LIMIT = %d < 0", l2));
        }
        long l3 = 0L;
        try {
            l3 = this.getStatementPropertyLong(102);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l3 < 0L) {
            throw new IllegalStateException(String.format("DSI_STMT_MAX_ROWS_MAX_LIMIT = %d < 0", l3));
        }
        if (l2 != 0L && l3 != 0L && l2 > l3) {
            throw new IllegalStateException(String.format("DSI_STMT_MAX_ROWS_MIN_LIMIT = %d > %d = DSI_STMT_MAX_ROWS_MAX_LIMIT", l2, l3));
        }
        if (l2 > l || 0L != l3 && l3 < l) {
            String string = 0L != l3 ? String.valueOf(l3) : String.valueOf(Long.MAX_VALUE);
            String string2 = String.valueOf(l2);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_MAX_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(l), string2, string);
        }
        this.setStatementProperty(2, 4, l);
    }

    @Override
    public synchronized void setQueryTimeout(int n) throws SQLException {
        long l = 0L;
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.checkIfOpen();
        try {
            l = this.getStatementPropertyLong(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = this.getStatementPropertyLong(104);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (l > (long)n || 0L != l2 && l2 < (long)n) {
                throw new Exception();
            }
            this.setStatementProperty(3, 4, n);
        }
        catch (Exception exception) {
            String string = String.valueOf(Double.POSITIVE_INFINITY);
            String string2 = String.valueOf(l);
            if (0L != l2) {
                string = String.valueOf(l2);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_TIMEOUT, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n), string2, string);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return null == this.m_statement || null == this.getParentConnection();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        this.checkIfOpen();
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), bl);
        this.checkIfOpen();
    }

    @Override
    public void setGeneratedValues(ParameterGeneratedValues parameterGeneratedValues) {
        this.m_generatedParams = parameterGeneratedValues;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    void closeIfPrepared() throws SQLException {
    }

    @Override
    public void closeIfIsPrepared() throws SQLException {
        this.closeIfPrepared();
    }

    void closeResults() throws SQLException {
        for (int i = this.getResultsets().size() - 1; i >= 0; --i) {
            BaseResultContext baseResultContext = this.getResultsets().get(i);
            if (ExecutionResultType.RESULT_SET != baseResultContext.m_resultType || baseResultContext.m_isResultClosed) continue;
            ((ResultSet)baseResultContext.m_result).close();
        }
    }

    @Override
    public void closeAllResults() throws SQLException {
        this.closeResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markResultSetClosed(ResultSet resultSet) throws SQLException {
        boolean bl = true;
        Object object = this.m_resultSetsLock;
        synchronized (object) {
            for (BaseResultContext baseResultContext : this.getResultsets()) {
                if (baseResultContext.m_result == resultSet) {
                    baseResultContext.m_isResultClosed = true;
                }
                if (ExecutionResultType.RESULT_SET != baseResultContext.m_resultType || baseResultContext.m_isResultClosed) continue;
                bl = false;
            }
        }
        if (bl && this.m_closeOnCompletion) {
            this.close();
        }
    }

    protected abstract void addResultPair(ExecutionResult var1);

    protected abstract void addResultSet(ResultSet var1);

    @Deprecated
    protected void checkCondition(String string, BaseThrowCondition baseThrowCondition) throws ErrorException, SQLException {
    }

    protected ExecutionResult checkAndMoveToNextResult(String string, BaseThrowCondition baseThrowCondition) throws SQLException {
        try {
            Iterator<ExecutionResult> iterator = this.getResultsIterator();
            if (!iterator.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTS_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
            ExecutionResult executionResult = this.moveToNextResult();
            this.addResultPair(executionResult);
            ExecutionResultType executionResultType = executionResult.getType();
            if ((BaseThrowCondition.FirstRowCount == baseThrowCondition || BaseThrowCondition.SingleRowCount == baseThrowCondition) && executionResultType != ExecutionResultType.ROW_COUNT && executionResultType != ExecutionResultType.ERROR_ROW_COUNT) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_ROWCOUNT_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
            if ((BaseThrowCondition.FirstResult == baseThrowCondition || BaseThrowCondition.SingleResult == baseThrowCondition) && executionResultType != ExecutionResultType.RESULT_SET && executionResultType != ExecutionResultType.ERROR_RESULT_SET) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NO_RESULTSET_GENERATED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
            if ((BaseThrowCondition.SingleRowCount == baseThrowCondition || BaseThrowCondition.SingleResult == baseThrowCondition) && iterator.hasNext()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.MULTIPLE_RESULTS_RETURNED, (IWarningListener)this.m_warningListener, ExceptionType.DATA, string);
            }
            return executionResult;
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
        }
    }

    protected void throwIfErrorResult(ExecutionResult executionResult, boolean bl) throws SQLException {
        if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType() || ExecutionResultType.ERROR_ROW_COUNT == executionResult.getType()) {
            try {
                if (bl && this.getResultsIterator().hasNext()) {
                    return;
                }
            }
            catch (ErrorException errorException) {
                throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
            }
            throw ExceptionConverter.getInstance().toSQLException(((IErrorResult)executionResult.getResult()).getError(), this.m_warningListener, this.m_logger);
        }
    }

    protected void checkIfNullSQL(String string) throws SQLException {
        if (null == string) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_SQL_STRING, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfOpen() throws SQLException {
        Object object = this.m_closeLock;
        synchronized (object) {
            if (null == this.m_statement) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.STATEMENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
        }
    }

    protected void clearResults() {
        if (null != this.getResultsets()) {
            for (BaseResultContext baseResultContext : this.getResultsets()) {
                try {
                    if (ExecutionResultType.RESULT_SET != baseResultContext.m_resultType || baseResultContext.m_isResultClosed) continue;
                    ((ResultSet)baseResultContext.m_result).close();
                }
                catch (Exception exception) {}
            }
            this.getResultsets().clear();
        }
        this.doClearResults();
        this.m_currentResultSetIndex = 0;
        if (this.m_generatedResult != null) {
            this.m_generatedResult.close();
        }
        this.m_generatedResult = DSIEmptyResultSet.INSTANCE;
    }

    protected abstract void doClearResults();

    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        return this.createResultSet((IResultSet)executionResult.getResult(), this.createsUpdatableResults(), this.getFetchSize());
    }

    protected abstract ResultSet createResultSet(R var1, boolean var2, int var3) throws SQLException;

    @Override
    public ResultSet newResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        return this.createResultSet(iResultSet, bl, n);
    }

    protected boolean createsUpdatableResults() {
        return 1007 != this.m_concurrency;
    }

    protected int[] processBatchResults(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list, BaseBatchType baseBatchType) throws ErrorException, SQLException {
        return new BatchExecutionContext(baseBatchType).processInt(iterator, list);
    }

    protected long[] processLargeBatchResults(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list, BaseBatchType baseBatchType) throws ErrorException, SQLException {
        return new BatchExecutionContext(baseBatchType).processLong(iterator, list);
    }

    protected void addToResultPair(boolean bl, long l) {
        if (bl) {
            this.addResultPair(new ExecutionResult(new DSISimpleRowCountResult(-1L)));
        } else {
            this.addResultPair(new ExecutionResult(new DSISimpleRowCountResult(l)));
        }
    }

    protected ExecutionResult moveToNextResult() throws SQLException {
        if (this.m_generatedResult != null) {
            this.m_generatedResult.close();
        }
        this.m_generatedParams = null;
        ExecutionResult executionResult = this.getNextResult();
        this.m_generatedResult = executionResult.getGeneratedResult();
        return executionResult;
    }

    protected abstract ExecutionResult getNextResult() throws SQLException;

    private void closeAllResultsToCurrent() throws SQLException {
        for (int i = 0; i < this.m_currentResultSetIndex; ++i) {
            BaseResultContext baseResultContext = this.getResultsets().get(i);
            if (ExecutionResultType.RESULT_SET != baseResultContext.m_resultType || baseResultContext.m_isResultClosed) continue;
            ((ResultSet)baseResultContext.m_result).close();
        }
    }

    protected abstract void executeNoParams(String var1, ParameterGeneratedValues var2, BaseThrowCondition var3) throws SQLException;

    private boolean getMoreResults(boolean bl) throws SQLException {
        if (this.getResultsets().size() > this.m_currentResultSetIndex) {
            BaseResultContext baseResultContext = this.getResultsets().get(this.m_currentResultSetIndex);
            if (bl && ExecutionResultType.RESULT_SET == baseResultContext.m_resultType && !baseResultContext.m_isResultClosed) {
                ((ResultSet)baseResultContext.m_result).close();
            }
            if (this.m_generatedResult != null) {
                this.m_generatedResult.close();
            }
            ++this.m_currentResultSetIndex;
            if (this.getResultsets().size() == this.m_currentResultSetIndex) {
                if (this.hasNextResult()) {
                    this.addResultPair(this.moveToNextResult());
                } else {
                    return false;
                }
            }
            baseResultContext = this.getResultsets().get(this.m_currentResultSetIndex);
            return ExecutionResultType.RESULT_SET == baseResultContext.m_resultType || ExecutionResultType.ERROR_RESULT_SET == baseResultContext.m_resultType;
        }
        return false;
    }

    private int getStatementPropertyInt(int n) throws SQLException {
        try {
            Variant variant = this.m_statement.getProperty(n);
            return variant.getInt();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private long getStatementPropertyLong(int n) throws SQLException {
        try {
            Variant variant = this.m_statement.getProperty(n);
            return variant.getLong();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void setStatementProperty(int n, int n2, Object object) throws SQLException {
        try {
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_SET_PROPERTY);
            this.m_statement.setProperty(n, new Variant(n2, object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    protected int castRowCount(long l) {
        return l > Integer.MAX_VALUE ? -2 : (int)l;
    }

    protected final void clearBatchSqlStatements() {
        this.m_batchSQLStatements.clear();
    }

    protected final List<String> getBatchSqlStatements() {
        return Collections.unmodifiableList(this.m_batchSQLStatements);
    }

    protected final String doSqlNativeSqlIfNeeded(String string) throws SQLException {
        try {
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                return this.m_statement.getParentConnection().toNativeSQL(string);
            }
            return string;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void onResultSetClosed(ResultSet resultSet) throws SQLException {
        this.markResultSetClosed(resultSet);
    }

    @Override
    public String getCursorName(ResultSet resultSet) throws SQLException {
        try {
            return this.m_statement.getCursorName();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public SConnection getJDBCConnection() {
        return this.m_parentConn;
    }

    @Override
    public IJDBCObjectFactory getObjectFactory() {
        return this.m_parentConn.getJDBCObjectFactory();
    }

    private class BatchExecutionContext {
        private List<SQLException> m_exceptions = null;
        private Boolean m_stopOnError = null;
        private final ArrayList<Long> m_results = new ArrayList();
        private long m_total = 0L;
        private boolean m_isTotalUnknown = false;
        private Iterator<ExecutionResult> m_resultIterator = null;
        private Iterator<Pair<Integer, SQLException>> m_errorIt = null;
        private Pair<Integer, SQLException> m_nextError = null;
        private int m_batchesUntilNextError = -1;
        private final BaseBatchType m_type;

        public BatchExecutionContext(BaseBatchType baseBatchType) {
            this.m_type = baseBatchType;
        }

        public int[] processInt(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list) throws BatchUpdateException, ErrorException {
            return (int[])this.doProcess(iterator, list, false);
        }

        public long[] processLong(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list) throws BatchUpdateException, ErrorException {
            return (long[])this.doProcess(iterator, list, true);
        }

        private Object doProcess(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list, boolean bl) throws BatchUpdateException, ErrorException {
            this.collectUpdateCounts(iterator, list);
            BaseStatement.this.addToResultPair(this.m_isTotalUnknown, this.m_total);
            return this.createResults(bl);
        }

        private void collectUpdateCounts(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list) throws ErrorException {
            this.initIterators(iterator, list);
            while (this.m_resultIterator.hasNext() || -1 != this.m_batchesUntilNextError) {
                boolean bl;
                if (this.m_batchesUntilNextError == 0) {
                    bl = true;
                    this.processConversionError();
                } else {
                    bl = this.processExecutionResult(this.m_resultIterator.next());
                    if (this.m_batchesUntilNextError > 0) {
                        --this.m_batchesUntilNextError;
                    }
                }
                if (!bl) continue;
                if (this.shouldStopOnError()) break;
                this.m_results.add(-3L);
            }
        }

        private Object createResults(boolean bl) throws BatchUpdateException {
            Object[] objectArray = bl ? this.toLongArray(this.m_results) : (Object[])this.toIntArray(this.m_results);
            BatchUpdateException batchUpdateException = this.createBatchUpdateException(objectArray);
            if (null != batchUpdateException) {
                throw batchUpdateException;
            }
            return objectArray;
        }

        private boolean shouldStopOnError() {
            if (this.m_stopOnError == null) {
                try {
                    switch (this.m_type) {
                        case MULTI_PARAM_SET: 
                        case MULTI_STATEMENT: {
                            long l = BaseStatement.this.m_statement.getParentConnection().getProperty(177).getLong();
                            long l2 = BaseBatchType.MULTI_PARAM_SET == this.m_type ? 2L : 1L;
                            this.m_stopOnError = (l & l2) == l2;
                            break;
                        }
                        case UNKNOWN: {
                            short s = DSIDriverSingleton.getInstance().getProperty(1001).getShort();
                            this.m_stopOnError = s == 1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid enum value: " + this.m_type.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    LogUtilities.logWarning(exception, BaseStatement.this.getLogger());
                    this.m_stopOnError = Boolean.TRUE;
                }
            }
            return this.m_stopOnError;
        }

        private int[] toIntArray(List<Long> list) {
            int[] nArray = new int[list.size()];
            int n = 0;
            for (Long l : list) {
                nArray[n++] = BaseStatement.longUpdateCountToInt(l);
            }
            return nArray;
        }

        private long[] toLongArray(List<Long> list) {
            long[] lArray = new long[list.size()];
            int n = 0;
            for (Long l : list) {
                lArray[n++] = l;
            }
            return lArray;
        }

        BatchUpdateException createBatchUpdateException(Object object) {
            if (object instanceof int[]) {
                return BaseStatement.createBatchUpdateException(this.m_exceptions, (int[])object);
            }
            return BaseStatement.largeBatchException(this.m_exceptions, (long[])object);
        }

        private void initIterators(Iterator<ExecutionResult> iterator, List<Pair<Integer, SQLException>> list) {
            this.m_resultIterator = iterator == null ? Collections.emptyList().iterator() : iterator;
            this.m_errorIt = list.iterator();
            this.updateNextError();
        }

        private void updateNextError() {
            if (this.m_errorIt.hasNext()) {
                this.m_nextError = this.m_errorIt.next();
                this.m_batchesUntilNextError = this.m_nextError.key();
            } else {
                this.m_nextError = null;
                this.m_batchesUntilNextError = -1;
            }
        }

        private boolean processExecutionResult(ExecutionResult executionResult) throws ErrorException {
            if (ExecutionResultType.ROW_COUNT == executionResult.getType()) {
                long l = ((IRowCountResult)executionResult.getResult()).getRowCount();
                if (-1L == l) {
                    this.m_results.add(-2L);
                    this.m_isTotalUnknown = true;
                } else {
                    if (l < 0L) {
                        throw new RuntimeException(String.format("Invalid rowcount returned: %d", l));
                    }
                    this.m_results.add(l);
                    if (!this.m_isTotalUnknown) {
                        if (this.m_total <= Long.MAX_VALUE - l) {
                            this.m_total += this.m_results.get(this.m_results.size() - 1).longValue();
                        } else {
                            this.m_isTotalUnknown = true;
                        }
                    }
                }
                return false;
            }
            if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_RETURNED, (IWarningListener)BaseStatement.this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                this.getExceptions().add(sQLException);
            } else {
                IErrorResult iErrorResult = (IErrorResult)executionResult.getResult();
                this.getExceptions().add(ExceptionConverter.getInstance().toSQLException(iErrorResult.getError(), BaseStatement.this.m_warningListener));
            }
            return true;
        }

        private void processConversionError() {
            assert (this.m_nextError != null && this.m_nextError.value() != null);
            this.getExceptions().add(this.m_nextError.value());
            this.updateNextError();
        }

        private List<SQLException> getExceptions() {
            if (this.m_exceptions == null) {
                this.m_exceptions = new ArrayList<SQLException>();
            }
            return this.m_exceptions;
        }
    }

    public static enum BaseBatchType {
        MULTI_STATEMENT,
        MULTI_PARAM_SET,
        UNKNOWN;

    }

    protected static enum BaseThrowCondition {
        None,
        SingleResult,
        SingleRowCount,
        FirstResult,
        FirstRowCount;

    }

    protected static class BaseResultContext {
        protected ExecutionResultType m_resultType;
        protected boolean m_isResultClosed = false;
        protected Object m_result = null;

        public BaseResultContext(IRowCountResult iRowCountResult) {
            this.m_resultType = ExecutionResultType.ROW_COUNT;
            this.m_result = iRowCountResult;
        }

        public BaseResultContext(ResultSet resultSet) {
            this.m_resultType = ExecutionResultType.RESULT_SET;
            this.m_result = resultSet;
        }

        public BaseResultContext(IErrorResult iErrorResult, boolean bl) {
            this.m_resultType = bl ? ExecutionResultType.ERROR_RESULT_SET : ExecutionResultType.ERROR_ROW_COUNT;
            this.m_result = iErrorResult;
        }

        public final ExecutionResultType getResultType() {
            return this.m_resultType;
        }

        public final boolean isResultClosed() {
            return this.m_isResultClosed;
        }

        public final Object getResult() {
            return this.m_result;
        }
    }
}

