/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.telemetry;

import com.databricks.client.jdbc.utils.StringUtils;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;

public class TelemetryUtil {
    private static final String FALL_BACK_PROCESS_NAME = "UnknownJavaProcess";

    public static String getProcessName(ILogger iLogger) {
        try {
            String string = TelemetryUtil.getProcessNameFromHandle(iLogger);
            if (!StringUtils.isNullOrEmpty(string)) {
                return string;
            }
            return FALL_BACK_PROCESS_NAME;
        }
        catch (Exception exception) {
            LogUtilities.logError(String.format("Error getting process name.", new Object[0]), iLogger);
            return FALL_BACK_PROCESS_NAME;
        }
    }

    public static String getProcessNameFromHandle(ILogger iLogger) {
        try {
            String string = System.getProperty("sun.java.command");
            if (!StringUtils.isNullOrEmpty(string)) {
                String[] stringArray = string.split(" ");
                return TelemetryUtil.getSimpleClassName(stringArray[0]);
            }
            return null;
        }
        catch (Exception exception) {
            LogUtilities.logError(String.format("Error getting process name from handle %s, returning null", exception.getMessage()), iLogger);
            return null;
        }
    }

    private static String getSimpleClassName(String string) {
        if (StringUtils.isNullOrEmpty(string)) {
            return null;
        }
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : string;
    }
}

