/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.context;

import com.dangdang.ddframe.job.context.ExecutionType;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public final class TaskContext {
    private static final String DELIMITER = "@-@";
    private static final String UNASSIGNED_SLAVE_ID = "unassigned-slave";
    private String id;
    private final MetaInfo metaInfo;
    private final ExecutionType type;
    private String slaveId;
    private boolean idle;

    public TaskContext(String jobName, List<Integer> shardingItem, ExecutionType type) {
        this(jobName, shardingItem, type, UNASSIGNED_SLAVE_ID);
    }

    public TaskContext(String jobName, List<Integer> shardingItem, ExecutionType type, String slaveId) {
        this.metaInfo = new MetaInfo(jobName, shardingItem);
        this.type = type;
        this.slaveId = slaveId;
        this.id = Joiner.on((String)DELIMITER).join((Object)this.metaInfo, (Object)type, new Object[]{slaveId, UUID.randomUUID().toString()});
    }

    private TaskContext(String id, MetaInfo metaInfo, ExecutionType type, String slaveId) {
        this.id = id;
        this.metaInfo = metaInfo;
        this.type = type;
        this.slaveId = slaveId;
    }

    public static TaskContext from(String id) {
        String[] result = id.split(DELIMITER);
        Preconditions.checkState((5 == result.length ? 1 : 0) != 0);
        return new TaskContext(id, MetaInfo.from(result[0] + DELIMITER + result[1]), ExecutionType.valueOf(result[2]), result[3]);
    }

    public static String getIdForUnassignedSlave(String id) {
        return id.replaceAll(TaskContext.from(id).getSlaveId(), UNASSIGNED_SLAVE_ID);
    }

    public void setSlaveId(String slaveId) {
        this.id = this.id.replaceAll(this.slaveId, slaveId);
        this.slaveId = slaveId;
    }

    public String getTaskName() {
        return Joiner.on((String)DELIMITER).join((Object)this.metaInfo, (Object)this.type, new Object[]{this.slaveId});
    }

    public String getExecutorId(String appName) {
        return Joiner.on((String)DELIMITER).join((Object)appName, (Object)this.slaveId, new Object[0]);
    }

    public String getId() {
        return this.id;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public ExecutionType getType() {
        return this.type;
    }

    public String getSlaveId() {
        return this.slaveId;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskContext)) {
            return false;
        }
        TaskContext other = (TaskContext)o;
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "TaskContext(id=" + this.getId() + ")";
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    public static class MetaInfo {
        private final String jobName;
        private final List<Integer> shardingItems;

        public static MetaInfo from(String value) {
            String[] result = value.split(TaskContext.DELIMITER);
            Preconditions.checkState((1 == result.length || 2 == result.length || 5 == result.length ? 1 : 0) != 0);
            return new MetaInfo(result[0], 1 == result.length || "".equals(result[1]) ? Collections.emptyList() : Lists.transform((List)Splitter.on((String)",").splitToList((CharSequence)result[1]), (Function)new Function<String, Integer>(){

                public Integer apply(String input) {
                    return Integer.parseInt(input);
                }
            }));
        }

        public String toString() {
            return Joiner.on((String)TaskContext.DELIMITER).join((Object)this.jobName, (Object)Joiner.on((String)",").join(this.shardingItems), new Object[0]);
        }

        @ConstructorProperties(value={"jobName", "shardingItems"})
        public MetaInfo(String jobName, List<Integer> shardingItems) {
            this.jobName = jobName;
            this.shardingItems = shardingItems;
        }

        public String getJobName() {
            return this.jobName;
        }

        public List<Integer> getShardingItems() {
            return this.shardingItems;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetaInfo)) {
                return false;
            }
            MetaInfo other = (MetaInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jobName = this.getJobName();
            String other$jobName = other.getJobName();
            if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
                return false;
            }
            List<Integer> this$shardingItems = this.getShardingItems();
            List<Integer> other$shardingItems = other.getShardingItems();
            return !(this$shardingItems == null ? other$shardingItems != null : !((Object)this$shardingItems).equals(other$shardingItems));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MetaInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jobName = this.getJobName();
            result = result * 59 + ($jobName == null ? 0 : $jobName.hashCode());
            List<Integer> $shardingItems = this.getShardingItems();
            result = result * 59 + ($shardingItems == null ? 0 : ((Object)$shardingItems).hashCode());
            return result;
        }
    }
}

