/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.api;

import com.dangdang.ddframe.job.executor.ShardingContexts;

public final class ShardingContext {
    private final String jobName;
    private final String taskId;
    private final int shardingTotalCount;
    private final String jobParameter;
    private final int shardingItem;
    private final String shardingParameter;

    public ShardingContext(ShardingContexts shardingContexts, int shardingItem) {
        this.jobName = shardingContexts.getJobName();
        this.taskId = shardingContexts.getTaskId();
        this.shardingTotalCount = shardingContexts.getShardingTotalCount();
        this.jobParameter = shardingContexts.getJobParameter();
        this.shardingItem = shardingItem;
        this.shardingParameter = shardingContexts.getShardingItemParameters().get(shardingItem);
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    public String getJobParameter() {
        return this.jobParameter;
    }

    public int getShardingItem() {
        return this.shardingItem;
    }

    public String getShardingParameter() {
        return this.shardingParameter;
    }

    public String toString() {
        return "ShardingContext(jobName=" + this.getJobName() + ", taskId=" + this.getTaskId() + ", shardingTotalCount=" + this.getShardingTotalCount() + ", jobParameter=" + this.getJobParameter() + ", shardingItem=" + this.getShardingItem() + ", shardingParameter=" + this.getShardingParameter() + ")";
    }
}

