/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.views;

import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.util.ReaderUtils;
import com.couchbase.mock.views.JavascriptRun;
import java.io.IOException;
import org.mozilla.javascript.BoundFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;

public class Indexer {
    private static final String INDEX_JS;
    private static final Object[] NO_ARGS;
    private final Scriptable scope;
    private final Function mapFunction;
    private final Function indexFunction;
    private Scriptable indexResults = null;

    private Indexer(String mapTxt, Context cx) {
        this.scope = new ImporterTopLevel(cx);
        cx.evaluateString(this.scope, INDEX_JS, "index.js", 1, null);
        cx.evaluateString(this.scope, JavascriptRun.getCollateJS(), "collate.js", 1, null);
        this.mapFunction = cx.compileFunction(this.scope, mapTxt, "map", 1, null);
        this.indexResults = cx.newObject(this.scope, "Index");
        this.indexFunction = (Function)this.indexResults.getPrototype().get("indexDoc", this.indexResults);
        Function emitFunc = (Function)this.indexResults.getPrototype().get("emit", this.indexResults);
        emitFunc = new BoundFunction(cx, this.scope, emitFunc, this.indexResults, NO_ARGS);
        this.scope.put("emit", this.scope, (Object)emitFunc);
    }

    public void run(Iterable<Item> items, Context cx) {
        Function prepareFunc = (Function)this.indexResults.getPrototype().get("prepare", this.indexResults);
        prepareFunc.call(cx, this.scope, this.indexResults, NO_ARGS);
        Object[] args = new Object[]{null, this.mapFunction};
        for (Item item : items) {
            args[0] = item;
            this.indexFunction.call(cx, this.scope, this.indexResults, args);
        }
        Function doneFunc = (Function)this.indexResults.getPrototype().get("setDone", this.indexResults);
        doneFunc.call(cx, this.scope, this.indexResults, NO_ARGS);
    }

    public static Indexer create(String mapTxt) {
        Context cx = Context.enter();
        try {
            Indexer indexer = new Indexer(mapTxt, cx);
            return indexer;
        }
        finally {
            Context.exit();
        }
    }

    Scriptable getLastResults() {
        return this.indexResults;
    }

    static {
        NO_ARGS = new Object[0];
        try {
            INDEX_JS = ReaderUtils.fromResource("views/index.js");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

