/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.protocol.BinaryArithmeticCommand;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetErrmapCommand;
import com.couchbase.mock.memcached.protocol.BinaryHelloCommand;
import com.couchbase.mock.memcached.protocol.BinaryObserveCommand;
import com.couchbase.mock.memcached.protocol.BinaryObserveSeqnoCommand;
import com.couchbase.mock.memcached.protocol.BinarySelectBucketCommand;
import com.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import com.couchbase.mock.memcached.protocol.BinarySubdocCommand;
import com.couchbase.mock.memcached.protocol.BinarySubdocMultiLookupCommand;
import com.couchbase.mock.memcached.protocol.BinarySubdocMultiMutationCommand;
import com.couchbase.mock.memcached.protocol.CommandCode;
import java.net.ProtocolException;
import java.nio.ByteBuffer;

public class CommandFactory {
    public static BinaryCommand create(ByteBuffer header) throws ProtocolException {
        header.rewind();
        if (header.get() != -128) {
            throw new ProtocolException("Illegal magic: " + header.get(0));
        }
        CommandCode cc = CommandCode.valueOf(header.get());
        header.rewind();
        switch (cc) {
            case ADD: 
            case ADDQ: 
            case APPEND: 
            case APPENDQ: 
            case PREPEND: 
            case PREPENDQ: 
            case SET: 
            case SETQ: 
            case REPLACE: 
            case REPLACEQ: {
                return new BinaryStoreCommand(header);
            }
            case INCREMENT: 
            case INCREMENTQ: 
            case DECREMENT: 
            case DECREMENTQ: {
                return new BinaryArithmeticCommand(header);
            }
            case GET: 
            case GETQ: 
            case GETK: 
            case GETKQ: 
            case GAT: 
            case GATQ: 
            case TOUCH: 
            case GETL: 
            case GET_REPLICA: {
                return new BinaryGetCommand(header);
            }
            case OBSERVE: {
                return new BinaryObserveCommand(header);
            }
            case HELLO: {
                return new BinaryHelloCommand(header);
            }
            case OBSERVE_SEQNO: {
                return new BinaryObserveSeqnoCommand(header);
            }
            case SUBDOC_EXISTS: 
            case SUBDOC_GET: 
            case SUBDOC_GET_COUNT: 
            case SUBDOC_COUNTER: 
            case SUBDOC_ARRAY_ADD_UNIQUE: 
            case SUBDOC_ARRAY_INSERT: 
            case SUBDOC_ARRAY_PUSH_FIRST: 
            case SUBDOC_ARRAY_PUSH_LAST: 
            case SUBDOC_DELETE: 
            case SUBDOC_REPLACE: 
            case SUBDOC_DICT_ADD: 
            case SUBDOC_DICT_UPSERT: {
                return new BinarySubdocCommand(header);
            }
            case SUBDOC_MULTI_LOOKUP: {
                return new BinarySubdocMultiLookupCommand(header);
            }
            case SUBDOC_MULTI_MUTATION: {
                return new BinarySubdocMultiMutationCommand(header);
            }
            case GET_ERRMAP: {
                return new BinaryGetErrmapCommand(header);
            }
            case SELECT_BUCKET: {
                return new BinarySelectBucketCommand(header);
            }
        }
        return new BinaryCommand(header);
    }

    private CommandFactory() {
    }
}

