/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.deps.org.iq80.snappy.Snappy;
import com.couchbase.mock.memcached.CompressionMode;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.nio.ByteBuffer;

public class BinaryGetResponse
extends BinaryResponse {
    public BinaryGetResponse(BinaryCommand command, ErrorCode error) {
        super(command, error);
    }

    public BinaryGetResponse(BinaryCommand command, ErrorCode error, String errorContext) {
        super(command, error, errorContext);
    }

    public BinaryGetResponse(BinaryCommand command, Item item, CompressionMode snappyMode) {
        super(BinaryGetResponse.create(command, item, snappyMode));
    }

    public BinaryGetResponse(BinaryGetCommand cmd, Item item, long casOverride, CompressionMode snappyMode) {
        super(BinaryGetResponse.create(cmd, item, casOverride, snappyMode));
    }

    private static ByteBuffer create(BinaryCommand command, Item item, CompressionMode snappyMode) {
        return BinaryGetResponse.create(command, item, null, snappyMode);
    }

    private static ByteBuffer create(BinaryCommand command, Item item, Long casOverride, CompressionMode snappyMode) {
        int keySize;
        byte[] keyBytes;
        switch (command.getComCode()) {
            case GETK: 
            case GETKQ: 
            case GET_REPLICA: {
                keyBytes = command.getKey().getBytes();
                keySize = command.getKey().length();
                break;
            }
            case GET_RANDOM: {
                keyBytes = item.getKeySpec().key.getBytes();
                keySize = item.getKeySpec().key.length();
                break;
            }
            default: {
                keySize = 0;
                keyBytes = null;
            }
        }
        byte[] value = item.getValue();
        byte datatype = item.getDatatype();
        switch (snappyMode) {
            case ACTIVE: {
                datatype = (byte)(datatype | ~Datatype.SNAPPY.value());
                value = Snappy.compress(value);
                break;
            }
            case PASSIVE: {
                if ((datatype & Datatype.SNAPPY.value()) <= 0) break;
                value = Snappy.compress(value);
                break;
            }
            default: {
                datatype = (byte)(datatype & ~Datatype.SNAPPY.value());
            }
        }
        ByteBuffer message = BinaryGetResponse.create(command, ErrorCode.SUCCESS, datatype, 4, keySize, value.length, casOverride == null ? item.getCas() : casOverride.longValue());
        message.putInt(item.getFlags());
        if (keySize > 0) {
            message.put(keyBytes);
        }
        message.put(value);
        message.rewind();
        return message;
    }
}

