/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.Datatype;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryConfigResponse
extends BinaryResponse {
    private BinaryConfigResponse(ByteBuffer buf) {
        super(buf);
        throw new UnsupportedOperationException();
    }

    public static BinaryResponse create(BinaryCommand command, MemcachedServer server, ErrorCode errOk, ErrorCode errNotSupp) {
        if (!server.isCccpEnabled()) {
            return new BinaryResponse(command, errNotSupp);
        }
        String config = server.getBucket().getJSON();
        config = config.replaceAll(Pattern.quote(server.getHostname()), Matcher.quoteReplacement("$HOST"));
        byte[] jsBytes = config.getBytes();
        ByteBuffer buf = BinaryConfigResponse.create(command, errOk, Datatype.RAW.value(), 0, 0, jsBytes.length, 0L);
        buf.put(jsBytes);
        buf.rewind();
        return new BinaryResponse(buf);
    }

    public static BinaryResponse createGetConfig(BinaryCommand command, MemcachedServer server) {
        return BinaryConfigResponse.create(command, server, ErrorCode.SUCCESS, ErrorCode.NOT_SUPPORTED);
    }

    public static BinaryResponse createNotMyVbucket(BinaryCommand command, MemcachedServer server) {
        return BinaryConfigResponse.create(command, server, ErrorCode.NOT_MY_VBUCKET, ErrorCode.NOT_MY_VBUCKET);
    }
}

