/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.client;

import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class MultiLookupResult {
    private final ErrorCode status;
    private final String value;

    MultiLookupResult(ErrorCode status, String value) {
        this.status = status;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public ErrorCode getStatus() {
        return this.status;
    }

    public boolean success() {
        return this.status == ErrorCode.SUCCESS;
    }

    public static List<MultiLookupResult> parse(ByteBuffer buf) {
        ArrayList<MultiLookupResult> results = new ArrayList<MultiLookupResult>();
        buf.rewind();
        while (buf.hasRemaining()) {
            short status = buf.getShort();
            ErrorCode ec = ErrorCode.valueOf(status);
            int valueLength = buf.getInt();
            byte[] vBytes = new byte[valueLength];
            buf.get(vBytes);
            String value = new String(vBytes);
            results.add(new MultiLookupResult(ec, value));
        }
        return results;
    }
}

