/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http;

import com.couchbase.mock.control.CommandNotFoundException;
import com.couchbase.mock.control.MockCommandDispatcher;
import com.couchbase.mock.control.handlers.MockHelpCommandHandler;
import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.deps.com.google.gson.JsonParser;
import com.couchbase.mock.deps.org.apache.http.Header;
import com.couchbase.mock.deps.org.apache.http.HttpEntityEnclosingRequest;
import com.couchbase.mock.deps.org.apache.http.HttpException;
import com.couchbase.mock.deps.org.apache.http.HttpRequest;
import com.couchbase.mock.deps.org.apache.http.HttpResponse;
import com.couchbase.mock.deps.org.apache.http.entity.ContentType;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpContext;
import com.couchbase.mock.deps.org.apache.http.protocol.HttpRequestHandler;
import com.couchbase.mock.deps.org.apache.http.util.EntityUtils;
import com.couchbase.mock.httpio.HandlerUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLDecoder;

public class ControlHandler
implements HttpRequestHandler {
    private final MockCommandDispatcher dispatcher;

    public ControlHandler(MockCommandDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private static void sendHelpText(HttpResponse response, int code) throws IOException {
        HandlerUtil.makeStringResponse(response, MockHelpCommandHandler.getIndentedHelp());
        response.setStatusCode(code);
    }

    private JsonObject getQueryPayload(URL url, HttpRequest request) throws HttpException, IOException {
        JsonObject payload = HandlerUtil.getJsonQuery(url);
        if (payload != null) {
            return payload;
        }
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            return null;
        }
        String encoded = EntityUtils.toString(((HttpEntityEnclosingRequest)request).getEntity());
        Header header = request.getLastHeader("Content-Type");
        if (header == null || header.getValue().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            url = new URL("http://foo.com?" + encoded);
            return HandlerUtil.getJsonQuery(url);
        }
        if (header.getValue().equals(ContentType.APPLICATION_JSON.getMimeType())) {
            JsonParser parser = new JsonParser();
            JsonElement elem = parser.parse(encoded);
            if (elem != null) {
                return elem.getAsJsonObject();
            }
            return null;
        }
        return null;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        URL url = HandlerUtil.getUrl(request);
        String path = url.getPath();
        path = path.replaceFirst("^/+", "");
        String[] components = path.split("/");
        try {
            if (components.length != 2) {
                throw new CommandNotFoundException("/mock/<COMMAND>", null);
            }
            if (components[1].equals("help")) {
                throw new WantHelpException();
            }
            JsonObject payload = this.getQueryPayload(url, request);
            String cmdStr = URLDecoder.decode(components[1], "UTF-8");
            String rStr = this.dispatcher.dispatch(cmdStr, payload).toString();
            HandlerUtil.makeJsonResponse(response, rStr);
        }
        catch (WantHelpException e) {
            ControlHandler.sendHelpText(response, 200);
        }
        catch (CommandNotFoundException e) {
            ControlHandler.sendHelpText(response, 404);
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(new PrintWriter(pw));
            HandlerUtil.makeStringResponse(response, sw.toString());
            HandlerUtil.bailResponse(context, response);
            throw e;
        }
    }

    private class WantHelpException
    extends Exception {
        private WantHelpException() {
        }
    }
}

