/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MissingRequiredFieldException;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.memcached.KeySpec;
import com.couchbase.mock.memcached.VBucketInfo;
import java.security.AccessControlException;
import org.jetbrains.annotations.NotNull;

public abstract class KeyCommandHandler
extends MockCommand {
    KeySpec keySpec;
    Bucket bucket;
    VBucketInfo vbi;

    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        short vbIndex = -1;
        String bucketString = "default";
        if (payload.has("Bucket")) {
            bucketString = payload.get("Bucket").getAsString();
        }
        this.bucket = mock.getBuckets().get(bucketString);
        if (this.bucket == null) {
            throw new AccessControlException("No such bucket: " + bucketString);
        }
        if (!payload.has("Key")) {
            throw new MissingRequiredFieldException("Key");
        }
        String key = payload.get("Key").getAsString();
        if (!payload.has("vBucket")) {
            vbIndex = this.bucket.getVbIndexForKey(key);
        }
        if (vbIndex < 0 || vbIndex >= this.bucket.getVBucketInfo().length) {
            throw new AccessControlException("Invalid vBucket " + vbIndex);
        }
        this.keySpec = new KeySpec(key, vbIndex);
        this.vbi = this.bucket.getVBucketInfo()[this.keySpec.vbId];
        return new CommandStatus().fail();
    }
}

