/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.memcached.CompressionMode;
import com.couchbase.mock.memcached.MemcachedServer;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class CompressionCommandHandler
extends MockCommand {
    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        HashSet<String> enabledBuckets = new HashSet<String>();
        HashSet<Integer> enabledServers = new HashSet<Integer>();
        CompressionMode mode = CompressionMode.of(payload.get("mode").getAsString());
        CompressionCommandHandler.loadBuckets(mock, payload, enabledBuckets);
        CompressionCommandHandler.loadServers(payload, enabledServers);
        for (Bucket bucket : mock.getBuckets().values()) {
            if (!enabledBuckets.contains(bucket.getName())) continue;
            MemcachedServer[] servers = bucket.getServers();
            for (int ii = 0; ii < servers.length; ++ii) {
                if (!enabledServers.isEmpty() && !enabledServers.contains(ii)) continue;
                servers[ii].setCompression(mode);
            }
        }
        return new CommandStatus();
    }
}

