/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.control.handlers.BucketCommandHandler;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.errormap.ErrorMap;
import com.couchbase.mock.memcached.errormap.RetrySpec;
import com.couchbase.mock.memcached.errormap.Verifier;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CheckRetryVerifyCommandHandler
extends BucketCommandHandler {
    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        super.execute(mock, command, payload);
        int opcode = payload.get("opcode").getAsInt();
        int errcode = payload.get("errcode").getAsInt();
        long fuzzms = 0L;
        if (payload.has("fuzz_ms")) {
            fuzzms = payload.get("fuzz_ms").getAsLong();
        }
        ArrayList<MemcachedServer.CommandLogEntry> entries = new ArrayList<MemcachedServer.CommandLogEntry>(this.bucket.getServers()[this.idx].getLogs());
        this.bucket.getServers()[this.idx].stopLog();
        RetrySpec spec = ErrorMap.DEFAULT_ERRMAP.getErrorEntry(errcode).getRetrySpec();
        try {
            Verifier.verifyThrow(entries, spec, opcode, fuzzms);
            return new CommandStatus();
        }
        catch (Verifier.VerificationException ex) {
            return new CommandStatus().fail(ex);
        }
    }
}

