/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.deps.com.google.gson.JsonElement;
import com.couchbase.mock.deps.com.google.gson.JsonObject;
import com.couchbase.mock.memcached.MemcachedServer;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SetSaslMechanismsCommandHandler
extends MockCommand {
    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        HashSet<Integer> enabledServers = new HashSet<Integer>();
        HashSet<String> enabledBuckets = new HashSet<String>();
        ArrayList<String> enabledMechs = new ArrayList<String>();
        for (JsonElement mech : payload.get("mechs").getAsJsonArray()) {
            enabledMechs.add(mech.getAsString());
        }
        SetSaslMechanismsCommandHandler.loadBuckets(mock, payload, enabledBuckets);
        SetSaslMechanismsCommandHandler.loadServers(payload, enabledServers);
        for (Bucket bucket : mock.getBuckets().values()) {
            if (!enabledBuckets.contains(bucket.getName())) continue;
            MemcachedServer[] servers = bucket.getServers();
            for (int ii = 0; ii < servers.length; ++ii) {
                if (!enabledServers.isEmpty() && !enabledServers.contains(ii)) continue;
                servers[ii].setSaslMechanisms(enabledMechs);
            }
        }
        return new CommandStatus();
    }
}

