/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.client;

import com.couchbase.mock.client.AbstractMockClient;
import com.couchbase.mock.client.MockRequest;
import com.couchbase.mock.client.MockResponse;
import com.couchbase.mock.deps.com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MockHttpClient
extends AbstractMockClient {
    private final InetSocketAddress restAddress;

    public MockHttpClient(@NotNull InetSocketAddress restAddress) {
        this.restAddress = restAddress;
    }

    private URL buildRequestUri(MockRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(this.restAddress.getHostName()).append(":").append(this.restAddress.getPort()).append("/mock/").append(URLEncoder.encode(request.getName(), "UTF-8")).append("?");
        this.appendPayload(sb, request.getPayload());
        return new URL(sb.toString());
    }

    private void appendPayload(StringBuilder sb, Map<String, Object> payload) throws UnsupportedEncodingException {
        Gson gson = new Gson();
        for (Map.Entry<String, Object> kv : payload.entrySet()) {
            String jStr = gson.toJson(kv.getValue());
            jStr = URLEncoder.encode(jStr, "UTF-8");
            sb.append(kv.getKey()).append('=').append(jStr).append('&');
        }
        int index = sb.lastIndexOf("&");
        if (index > 0) {
            sb.deleteCharAt(index);
        }
    }

    @Override
    @NotNull
    public MockResponse request(@NotNull MockRequest request) throws IOException {
        URL url = this.buildRequestUri(request);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.connect();
        return new MockResponse(this.readResponse(uc.getInputStream()));
    }

    private String readResponse(@NotNull InputStream input) throws IOException {
        int nr;
        StringBuilder sb = new StringBuilder();
        byte[] buf = new byte[4096];
        while ((nr = input.read(buf)) != -1) {
            sb.append(new String(buf, 0, nr));
        }
        return sb.toString();
    }
}

