/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.client;

import com.couchbase.mock.client.MockRequest;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class KeyAccessRequest
extends MockRequest {
    KeyAccessRequest(@NotNull String key, @NotNull String value, boolean onMaster, int numReplicas, long cas, @NotNull String bucket) {
        this.payload.put("Key", key);
        if (!value.isEmpty()) {
            this.payload.put("Value", value);
        }
        if (!bucket.isEmpty()) {
            this.payload.put("Bucket", bucket);
        }
        if (cas != 0L) {
            this.payload.put("CAS", cas);
        }
        this.payload.put("OnMaster", onMaster);
        this.payload.put("OnReplicas", numReplicas);
        this.command.put("payload", this.payload);
    }

    KeyAccessRequest(@NotNull String key, @NotNull String value, boolean onMaster, @NotNull List<Integer> replicaIds, long cas, @NotNull String bucket) {
        this.payload.put("Key", key);
        if (!value.isEmpty()) {
            this.payload.put("Value", value);
        }
        if (!bucket.isEmpty()) {
            this.payload.put("Bucket", bucket);
        }
        if (cas != 0L) {
            this.payload.put("CAS", cas);
        }
        this.payload.put("OnMaster", onMaster);
        this.payload.put("OnReplicas", replicaIds);
        this.command.put("payload", this.payload);
    }
}

