/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.AbstractContext;
import com.couchbase.client.core.cnc.events.endpoint.EndpointStateChangedEvent;
import com.couchbase.client.core.deps.io.grpc.Attributes;
import com.couchbase.client.core.deps.io.grpc.CallCredentials;
import com.couchbase.client.core.deps.io.grpc.CallOptions;
import com.couchbase.client.core.deps.io.grpc.Channel;
import com.couchbase.client.core.deps.io.grpc.ClientCall;
import com.couchbase.client.core.deps.io.grpc.ClientInterceptor;
import com.couchbase.client.core.deps.io.grpc.ClientStreamTracer;
import com.couchbase.client.core.deps.io.grpc.ConnectivityState;
import com.couchbase.client.core.deps.io.grpc.EquivalentAddressGroup;
import com.couchbase.client.core.deps.io.grpc.ManagedChannel;
import com.couchbase.client.core.deps.io.grpc.ManagedChannelBuilder;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.MethodDescriptor;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.grpc.netty.GrpcSslContexts;
import com.couchbase.client.core.deps.io.grpc.netty.NettyChannelBuilder;
import com.couchbase.client.core.deps.io.netty.channel.ChannelOption;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslContext;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.endpoint.CircuitBreaker;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.endpoint.MultiAddressNameResolverFactory;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.SecurityException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.protostellar.GrpcAwareRequestTracer;
import com.couchbase.client.core.protostellar.ProtostellarContext;
import com.couchbase.client.core.protostellar.ProtostellarStatsCollector;
import com.couchbase.client.core.util.Deadline;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.protostellar.admin.bucket.v1.BucketAdminServiceGrpc;
import com.couchbase.client.protostellar.admin.collection.v1.CollectionAdminServiceGrpc;
import com.couchbase.client.protostellar.admin.search.v1.SearchAdminServiceGrpc;
import com.couchbase.client.protostellar.analytics.v1.AnalyticsServiceGrpc;
import com.couchbase.client.protostellar.internal.hooks.v1.HooksServiceGrpc;
import com.couchbase.client.protostellar.kv.v1.KvServiceGrpc;
import com.couchbase.client.protostellar.query.v1.QueryServiceGrpc;
import com.couchbase.client.protostellar.search.v1.SearchServiceGrpc;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;

public class ProtostellarEndpoint {
    public static ProtostellarStatsCollector collector;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ManagedChannel managedChannel;
    private final KvServiceGrpc.KvServiceFutureStub kvStub;
    private final KvServiceGrpc.KvServiceBlockingStub kvBlockingStub;
    private final AnalyticsServiceGrpc.AnalyticsServiceStub analyticsStub;
    private final QueryServiceGrpc.QueryServiceStub queryStub;
    private final SearchServiceGrpc.SearchServiceStub searchStub;
    private final HooksServiceGrpc.HooksServiceBlockingStub hooksBlockingStub;
    private final CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub collectionAdminStub;
    private final BucketAdminServiceGrpc.BucketAdminServiceFutureStub bucketAdminStub;
    private final SearchAdminServiceGrpc.SearchAdminServiceFutureStub searchAdminStub;
    private final HostAndPort remote;
    private final CoreEnvironment env;
    private final ProtostellarContext ctx;

    public ProtostellarEndpoint(ProtostellarContext ctx, HostAndPort remote) {
        String override = System.getProperty("com.couchbase.protostellar.overrideHostname");
        this.remote = override != null ? new HostAndPort(override, remote.port()) : remote;
        this.ctx = Objects.requireNonNull(ctx);
        this.env = ctx.environment();
        this.managedChannel = this.channel(ctx);
        ConnectivityState now = this.managedChannel.getState(false);
        this.notifyOnChannelStateChange(now);
        CallCredentials creds = ctx.authenticator().protostellarCallCredentials();
        final ClientStreamTracer.Factory factory = new ClientStreamTracer.Factory(){

            @Override
            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return new ClientStreamTracer(){

                    @Override
                    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
                        super.outboundMessageSent(seqNo, optionalWireSize, optionalUncompressedSize);
                        if (collector != null) {
                            collector.outboundMessageSent();
                        }
                    }

                    @Override
                    public void outboundMessage(int seqNo) {
                        super.outboundMessage(seqNo);
                        if (collector != null) {
                            collector.outboundMessage();
                        }
                    }

                    @Override
                    public void inboundMessage(int seqNo) {
                        super.inboundMessage(seqNo);
                        if (collector != null) {
                            collector.inboundMessage();
                        }
                    }

                    @Override
                    public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
                        super.inboundMessageRead(seqNo, optionalWireSize, optionalUncompressedSize);
                        if (collector != null) {
                            collector.inboundMessageRead();
                        }
                    }

                    @Override
                    public void streamCreated(Attributes transportAttrs, Metadata headers) {
                        super.streamCreated(transportAttrs, headers);
                    }

                    @Override
                    public void streamClosed(Status status) {
                        super.streamClosed(status);
                    }
                };
            }
        };
        ClientInterceptor ci = new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return next.newCall(method, callOptions.withStreamTracerFactory(factory));
            }
        };
        this.kvStub = (KvServiceGrpc.KvServiceFutureStub)((KvServiceGrpc.KvServiceFutureStub)KvServiceGrpc.newFutureStub(this.managedChannel).withInterceptors(ci)).withCallCredentials(creds);
        this.kvBlockingStub = (KvServiceGrpc.KvServiceBlockingStub)((KvServiceGrpc.KvServiceBlockingStub)KvServiceGrpc.newBlockingStub(this.managedChannel).withInterceptors(ci)).withCallCredentials(creds);
        this.analyticsStub = (AnalyticsServiceGrpc.AnalyticsServiceStub)AnalyticsServiceGrpc.newStub(this.managedChannel).withCallCredentials(creds);
        this.queryStub = (QueryServiceGrpc.QueryServiceStub)QueryServiceGrpc.newStub(this.managedChannel).withCallCredentials(creds);
        this.searchStub = (SearchServiceGrpc.SearchServiceStub)SearchServiceGrpc.newStub(this.managedChannel).withCallCredentials(creds);
        this.hooksBlockingStub = (HooksServiceGrpc.HooksServiceBlockingStub)HooksServiceGrpc.newBlockingStub(this.managedChannel).withCallCredentials(creds);
        this.collectionAdminStub = (CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub)CollectionAdminServiceGrpc.newFutureStub(this.managedChannel).withCallCredentials(creds);
        this.bucketAdminStub = (BucketAdminServiceGrpc.BucketAdminServiceFutureStub)BucketAdminServiceGrpc.newFutureStub(this.managedChannel).withCallCredentials(creds);
        this.searchAdminStub = (SearchAdminServiceGrpc.SearchAdminServiceFutureStub)SearchAdminServiceGrpc.newFutureStub(this.managedChannel).withCallCredentials(creds);
    }

    private ManagedChannel channel(ProtostellarContext ctx) {
        SslContext sslContext;
        block10: {
            SecurityConfig securityConfig = ctx.environment().securityConfig();
            try {
                if (securityConfig.trustManagerFactory() != null) {
                    sslContext = GrpcSslContexts.forClient().trustManager(securityConfig.trustManagerFactory()).build();
                    break block10;
                }
                if (!securityConfig.trustCertificates().isEmpty()) {
                    sslContext = GrpcSslContexts.forClient().trustManager(securityConfig.trustCertificates()).build();
                    break block10;
                }
                throw new CouchbaseException("Internal bug - should not reach here");
            }
            catch (SSLException e) {
                throw new SecurityException(e);
            }
        }
        Object builder = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(this.remote.host(), this.remote.port()).sslContext(sslContext).maxInboundMessageSize(0x1500000).executor(this.env.executor())).withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)this.env.timeoutConfig().connectTimeout().toMillis()).disableRetry();
        if (ctx.environment().requestTracer() != null && ctx.environment().requestTracer() instanceof GrpcAwareRequestTracer) {
            ((GrpcAwareRequestTracer)((Object)ctx.environment().requestTracer())).registerGrpc((ManagedChannelBuilder<?>)builder);
        }
        String loadBalancingCount = System.getProperty("com.couchbase.protostellar.loadBalancing");
        String loadBalancingStrategy = System.getProperty("com.couchbase.protostellar.loadBalancingStrategy", "round_robin");
        String loadBalancingSingle = System.getProperty("com.couchbase.protostellar.loadBalancingSingle", "true");
        if (loadBalancingCount != null) {
            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
            int count = Integer.parseInt(loadBalancingCount);
            boolean single = Boolean.parseBoolean(loadBalancingSingle);
            if (single) {
                ArrayList<SocketAddress> adds = new ArrayList<SocketAddress>();
                for (int i = 0; i < count; ++i) {
                    adds.add(ProtostellarEndpoint.newInetSocketAddress(this.remote));
                }
                addresses.add(new EquivalentAddressGroup(adds));
            } else {
                for (int i = 0; i < count; ++i) {
                    addresses.add(new EquivalentAddressGroup(ProtostellarEndpoint.newInetSocketAddress(this.remote)));
                }
            }
            MultiAddressNameResolverFactory nameResolverFactory = new MultiAddressNameResolverFactory(addresses);
            ((ManagedChannelBuilder)((ManagedChannelBuilder)builder).nameResolverFactory(nameResolverFactory)).defaultLoadBalancingPolicy(loadBalancingStrategy);
        }
        return ((ManagedChannelBuilder)builder).build();
    }

    private static InetSocketAddress newInetSocketAddress(HostAndPort hostAndPort) {
        return new InetSocketAddress(hostAndPort.host(), hostAndPort.port());
    }

    private void notifyOnChannelStateChange(ConnectivityState current) {
        this.managedChannel.notifyWhenStateChanged(current, () -> {
            ConnectivityState now = this.managedChannel.getState(false);
            ProtostellarEndpointContext ec = new ProtostellarEndpointContext(this.ctx, this.remote);
            this.env.eventBus().publish(new EndpointStateChangedEvent(ec, ProtostellarEndpoint.convert(current), ProtostellarEndpoint.convert(now)));
            this.notifyOnChannelStateChange(now);
        });
    }

    private static EndpointState convert(ConnectivityState state) {
        switch (state) {
            case IDLE: {
                return EndpointState.DISCONNECTED;
            }
            case READY: {
                return EndpointState.CONNECTED;
            }
            case SHUTDOWN: {
                return EndpointState.DISCONNECTING;
            }
            case TRANSIENT_FAILURE: 
            case CONNECTING: {
                return EndpointState.CONNECTING;
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)state));
    }

    public EndpointDiagnostics diagnostics() {
        return new EndpointDiagnostics(null, ProtostellarEndpoint.convert(this.managedChannel.getState(false)), CircuitBreaker.State.CLOSED, null, this.remote.format(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public synchronized void shutdown(Duration timeout) {
        if (this.shutdown.compareAndSet(false, true)) {
            this.managedChannel.shutdown();
            try {
                this.managedChannel.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public KvServiceGrpc.KvServiceFutureStub kvStub() {
        return this.kvStub;
    }

    public KvServiceGrpc.KvServiceBlockingStub kvBlockingStub() {
        return this.kvBlockingStub;
    }

    public AnalyticsServiceGrpc.AnalyticsServiceStub analyticsStub() {
        return this.analyticsStub;
    }

    public QueryServiceGrpc.QueryServiceStub queryStub() {
        return this.queryStub;
    }

    public SearchServiceGrpc.SearchServiceStub searchStub() {
        return this.searchStub;
    }

    public HooksServiceGrpc.HooksServiceBlockingStub hooksBlockingStub() {
        return this.hooksBlockingStub;
    }

    public CollectionAdminServiceGrpc.CollectionAdminServiceFutureStub collectionAdminStub() {
        return this.collectionAdminStub;
    }

    public BucketAdminServiceGrpc.BucketAdminServiceFutureStub bucketAdminStub() {
        return this.bucketAdminStub;
    }

    public SearchAdminServiceGrpc.SearchAdminServiceFutureStub searchAdminStub() {
        return this.searchAdminStub;
    }

    public synchronized boolean isShutdown() {
        return this.shutdown.get();
    }

    public HostAndPort hostAndPort() {
        return this.remote;
    }

    @Stability.Internal
    public CompletableFuture<Void> waitUntilReady(Deadline deadline, boolean waitingForReady) {
        CompletableFuture<Void> onDone = new CompletableFuture<Void>();
        ConnectivityState current = this.managedChannel.getState(true);
        this.notify(current, onDone, deadline, waitingForReady);
        return onDone;
    }

    private void notify(ConnectivityState current, CompletableFuture<Void> onDone, Deadline deadline, boolean waitingForReady) {
        if (this.inDesiredState(current, waitingForReady)) {
            onDone.complete(null);
        } else {
            this.ctx.environment().timer().schedule(() -> {
                ConnectivityState now = this.managedChannel.getState(true);
                if (this.inDesiredState(current, waitingForReady)) {
                    onDone.complete(null);
                } else if (deadline.exceeded()) {
                    onDone.completeExceptionally(new UnambiguousTimeoutException("Timed out while waiting for Protostellar endpoint " + this.remote, new CancellationErrorContext(null)));
                } else {
                    this.notify(now, onDone, deadline, waitingForReady);
                }
            }, Duration.ofMillis(50L));
        }
    }

    private boolean inDesiredState(ConnectivityState current, boolean waitingForReady) {
        return waitingForReady && current == ConnectivityState.READY || !waitingForReady && current != ConnectivityState.READY;
    }

    private static class ProtostellarEndpointContext
    extends AbstractContext {
        private final ProtostellarContext ctx;
        private final HostAndPort remote;

        public ProtostellarEndpointContext(ProtostellarContext ctx, HostAndPort remote) {
            this.ctx = Objects.requireNonNull(ctx);
            this.remote = Objects.requireNonNull(remote);
        }

        @Override
        public void injectExportableParams(Map<String, Object> input) {
            this.ctx.injectExportableParams(input);
            input.put("remote", this.remote.toString());
        }
    }
}

