/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.AbstractBucketConfig;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ConfigVersion;
import com.couchbase.client.core.config.LegacyConfigHelper;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JacksonInject;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.ClusterTopology;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import reactor.util.annotation.Nullable;

@Deprecated
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlobalConfig {
    private final ConfigVersion version;
    private final List<PortInfo> portInfos;
    private final Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities;
    @Nullable
    private final ClusterTopology clusterTopology;

    public GlobalConfig(ClusterTopology topology) {
        this.version = LegacyConfigHelper.toLegacy(topology.revision());
        this.portInfos = LegacyConfigHelper.getPortInfos(topology);
        this.clusterCapabilities = LegacyConfigHelper.getClusterCapabilities(topology);
        this.clusterTopology = topology;
    }

    @JsonCreator
    public GlobalConfig(@JsonProperty(value="rev") long rev, @JsonProperty(value="revEpoch") long revEpoch, @JsonProperty(value="nodesExt") List<PortInfo> portInfos, @JsonProperty(value="clusterCapabilities") Map<String, Set<ClusterCapabilities>> clusterCapabilities, @JacksonInject(value="origin") String origin) {
        this.version = new ConfigVersion(revEpoch, rev);
        this.portInfos = this.enrichPortInfos(portInfos, origin);
        this.clusterCapabilities = AbstractBucketConfig.convertClusterCapabilities(clusterCapabilities);
        this.clusterTopology = null;
    }

    private List<PortInfo> enrichPortInfos(List<PortInfo> portInfos, String origin) {
        ArrayList<PortInfo> enriched = new ArrayList<PortInfo>(portInfos.size());
        for (PortInfo portInfo : portInfos) {
            if (portInfo.hostname() == null) {
                enriched.add(new PortInfo(portInfo.ports(), portInfo.sslPorts(), portInfo.alternateAddresses(), origin, portInfo.serverGroup()));
                continue;
            }
            enriched.add(portInfo);
        }
        return enriched;
    }

    @Deprecated
    public long rev() {
        return this.version().rev();
    }

    @Deprecated
    public long revEpoch() {
        return this.version.epoch();
    }

    public ConfigVersion version() {
        return this.version;
    }

    public Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities() {
        return this.clusterCapabilities;
    }

    public List<PortInfo> portInfos() {
        return this.portInfos;
    }

    @Stability.Internal
    ClusterTopology asClusterTopology() {
        if (this.clusterTopology == null) {
            throw new IllegalStateException("This GlobalConfig instance was not created from a ClusterTopology.");
        }
        return this.clusterTopology;
    }

    public String toString() {
        return "GlobalConfig{version=" + this.version + ", portInfos=" + this.portInfos + ", clusterCapabilities=" + this.clusterCapabilities + '}';
    }
}

