/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;
import javax.net.ssl.SSLException;

public class SecureConnectionFailedEvent
extends AbstractEvent {
    private final SSLException sslException;

    public SecureConnectionFailedEvent(Context context, SSLException sslException) {
        super(Event.Severity.ERROR, Event.Category.IO, Duration.ZERO, context);
        this.sslException = sslException;
    }

    public SSLException sslException() {
        return this.sslException;
    }

    @Override
    public String description() {
        String cause = this.sslException.getCause() != null ? this.sslException.getCause().toString() : "(none)";
        return "Detected a TLS problem in the IO layer: " + this.sslException + ", Cause: " + cause;
    }
}

