/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.protostellar.search.v1.BooleanFieldQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreBooleanFieldQuery
extends CoreSearchQuery {
    private final boolean value;
    @Nullable
    private final String field;

    public CoreBooleanFieldQuery(boolean value, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.value = value;
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        if (this.field != null) {
            input.put("field", this.field);
        }
        input.put("bool", this.value);
    }

    @Override
    public Query asProtostellar() {
        BooleanFieldQuery.Builder builder = BooleanFieldQuery.newBuilder().setValue(this.value);
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setBooleanFieldQuery(builder).build();
    }
}

