/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CompactIntMap;
import com.couchbase.client.core.util.SparseIntMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

@Stability.Internal
public interface IntMap<E> {
    @Nullable
    public E get(int var1);

    @Nullable
    default public E get(short key) {
        return this.get(key & 0xFFFF);
    }

    @Nullable
    default public E get(byte key) {
        return this.get(key & 0xFF);
    }

    public static <E extends Enum<?>> IntMap<E> from(Class<E> enumClass, Function<E, Integer> keyExtractor) {
        return IntMap.from(Arrays.asList(enumClass.getEnumConstants()), keyExtractor);
    }

    public static <E> IntMap<E> from(Iterable<E> items, Function<E, Integer> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        HashMap<Integer, E> map = new HashMap<Integer, E>();
        for (E value : items) {
            Integer key = keyExtractor.apply(value);
            E existing = map.put(key, value);
            if (existing == null) continue;
            throw new IllegalArgumentException("Generated keys for IntMap must be unique, but " + key + " was mapped to both '" + existing + "' and '" + value + "'.");
        }
        return IntMap.from(map);
    }

    public static <E> IntMap<E> from(Map<Integer, E> map) {
        if (map.isEmpty()) {
            return CompactIntMap.empty();
        }
        for (Integer key2 : map.keySet()) {
            if (key2 != null && key2 >= 0) continue;
            throw new IllegalArgumentException("IntMap key must be non-null and non-negative, but got: " + key2);
        }
        int maxIndex = (Integer)map.keySet().stream().max(Integer::compareTo).get();
        int wastedArrayElements = maxIndex + 1 - map.size();
        if (wastedArrayElements > 1024) {
            return new SparseIntMap<E>(map);
        }
        Object[] indexToValue = new Object[maxIndex + 1];
        map.forEach((key, value) -> {
            indexToValue[key.intValue()] = value;
        });
        return new CompactIntMap(indexToValue);
    }
}

