/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

@Stability.Internal
public final class CoreExpiry {
    public static final Instant LATEST_VALID_EXPIRY_INSTANT = Instant.ofEpochSecond(0xFFFFFFFFL);
    public static final Instant EARLIEST_VALID_EXPIRY_INSTANT = Instant.ofEpochSecond(TimeUnit.DAYS.toSeconds(30L) + 1L);
    @Nullable
    private final Duration relative;
    @Nullable
    private final Instant absolute;
    public static final CoreExpiry NONE = new CoreExpiry();

    private CoreExpiry() {
        this.relative = null;
        this.absolute = null;
    }

    private CoreExpiry(Duration relative) {
        this.relative = Objects.requireNonNull(relative);
        this.absolute = null;
    }

    private CoreExpiry(Instant absolute) {
        this.relative = null;
        this.absolute = Objects.requireNonNull(absolute);
    }

    public static CoreExpiry of(Duration duration) {
        if (duration.isZero()) {
            return NONE;
        }
        if (duration.getSeconds() < 1L) {
            throw InvalidArgumentException.fromMessage("A non-zero expiry duration must be >= 1 second, but got " + duration);
        }
        return new CoreExpiry(duration);
    }

    public static CoreExpiry of(Instant instant) {
        if (instant.equals(Instant.EPOCH)) {
            return NONE;
        }
        if (instant.isAfter(LATEST_VALID_EXPIRY_INSTANT)) {
            throw InvalidArgumentException.fromMessage("Requested expiry " + instant + " is too far in the future; must be <= " + LATEST_VALID_EXPIRY_INSTANT);
        }
        if (instant.isBefore(EARLIEST_VALID_EXPIRY_INSTANT)) {
            throw InvalidArgumentException.fromMessage("Requested expiry " + instant + " is too far in the past; must be >= " + EARLIEST_VALID_EXPIRY_INSTANT);
        }
        return new CoreExpiry(instant);
    }

    public boolean isNone() {
        return this == NONE;
    }

    @Nullable
    public Duration relative() {
        return this.relative;
    }

    @Nullable
    public Instant absolute() {
        return this.absolute;
    }

    public void when(Consumer<Instant> ifAbsolute, Consumer<Duration> ifRelative, Runnable ifNone) {
        if (this.isNone()) {
            ifNone.run();
        } else if (this.relative != null) {
            ifRelative.accept(this.relative);
        } else if (this.absolute != null) {
            ifAbsolute.accept(this.absolute);
        } else {
            throw new AssertionError((Object)"invariant failed");
        }
    }

    public String toString() {
        if (this == NONE) {
            return "none";
        }
        return this.relative != null ? this.relative.toString() : String.valueOf(this.absolute);
    }
}

