/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.retry.RetryAction;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.retry.reactor.Backoff;
import com.couchbase.client.core.retry.reactor.BackoffDelay;
import com.couchbase.client.core.retry.reactor.IterationContext;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public class BestEffortRetryStrategy
implements RetryStrategy {
    private static final Backoff DEFAULT_EXPONENTIAL_BACKOFF = Backoff.exponential(Duration.ofMillis(1L), Duration.ofMillis(500L), 2, false);
    public static final BestEffortRetryStrategy INSTANCE = new BestEffortRetryStrategy(DEFAULT_EXPONENTIAL_BACKOFF);
    private final Backoff backoff;

    protected BestEffortRetryStrategy() {
        this(DEFAULT_EXPONENTIAL_BACKOFF);
    }

    protected BestEffortRetryStrategy(Backoff backoff) {
        this.backoff = backoff;
    }

    public static BestEffortRetryStrategy withExponentialBackoff(Duration lower, Duration upper, int factor) {
        return new BestEffortRetryStrategy(Backoff.exponential(lower, upper, factor, false));
    }

    @Override
    public CompletableFuture<RetryAction> shouldRetry(Request<? extends Response> request, RetryReason reason) {
        if (request.idempotent() || reason.allowsNonIdempotentRetry()) {
            RequestContext ctx = request.context();
            return CompletableFuture.completedFuture(RetryAction.withDuration(((BackoffDelay)this.backoff.apply(new RetryStrategyIterationContext(ctx.retryAttempts(), ctx.lastRetryDuration()))).delay()));
        }
        return CompletableFuture.completedFuture(RetryAction.noRetry());
    }

    public String toString() {
        return "BestEffort{backoff=" + this.backoff + "}";
    }

    private static class RetryStrategyIterationContext
    implements IterationContext<Void> {
        private final long iteration;
        private final Duration lastBackoff;

        RetryStrategyIterationContext(long iteration, Duration lastBackoff) {
            this.iteration = iteration;
            this.lastBackoff = lastBackoff;
        }

        @Override
        public Void applicationContext() {
            return null;
        }

        @Override
        public long iteration() {
            return this.iteration;
        }

        @Override
        public Duration backoff() {
            return this.lastBackoff;
        }
    }
}

