/*
 * Decompiled with CFR 0.152.
 */
package com.cosium.code.format;

import com.cosium.code.format.AbstractFormatMojo;
import com.cosium.code.format.MavenGitCodeFormatException;
import com.cosium.code.format.formatter.CodeFormatters;
import com.cosium.code.format_spi.CodeFormatter;
import com.cosium.code.format_spi.FileExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="validate-code-format", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class ValidateCodeFormat
extends AbstractFormatMojo {
    @Override
    protected void process(CodeFormatters codeFormatters, Path path) throws MojoFailureException {
        if (this.validate(codeFormatters, path)) {
            return;
        }
        throw new MojoFailureException(path + " is not correctly formatted !");
    }

    private boolean validate(CodeFormatters codeFormatters, Path path) {
        return codeFormatters.forFileExtension(FileExtension.parse((Path)path)).stream().map(formatter -> this.doValidate(path, (CodeFormatter)formatter)).filter(valid -> valid == false).findFirst().orElse(true);
    }

    private boolean doValidate(Path path, CodeFormatter formatter) {
        boolean bl;
        block8: {
            Path relativePath = this.gitBaseDir().relativize(path);
            this.getLog().debug((CharSequence)("Validating '" + relativePath + "'"));
            InputStream content = Files.newInputStream(path, new OpenOption[0]);
            try {
                bl = formatter.validate(content);
                if (content == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new MavenGitCodeFormatException(String.format("Failed to validate '%s': %s", relativePath, e.getMessage()), e);
                }
            }
            content.close();
        }
        return bl;
    }
}

