/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.Field;
import com.codoid.products.fillo.Select;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Recordset {
    private Object oRecordset;
    private int inRowNum = -1;
    private boolean blRecordsetStatus = false;
    private Map<String, String> colsNamesMap;
    private String strTableName;

    public Recordset(Object oRecordset) throws FilloException {
        Object rows = null;
        try {
            rows = ((Map)oRecordset).get("ROWS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rows == null) {
            throw new FilloException("No records found");
        }
        if (((Map)rows).size() == 0) {
            throw new FilloException("No records found");
        }
        this.oRecordset = rows;
        this.colsNamesMap = (Map)((Map)oRecordset).get("COLS");
        this.strTableName = ((Map)((Map)oRecordset).get("TABLE")).get("NAME").toString();
        this.blRecordsetStatus = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void moveNext() throws FilloException {
        if (!this.blRecordsetStatus) throw new FilloException("Recordset Closed");
        if (((Map)this.oRecordset).size() - 1 == this.inRowNum) throw new FilloException("EOF Recordset");
        ++this.inRowNum;
    }

    public boolean next() throws FilloException {
        boolean blResult = false;
        if (this.blRecordsetStatus) {
            if (((Map)this.oRecordset).size() - 1 != this.inRowNum) {
                ++this.inRowNum;
                blResult = true;
            } else {
                blResult = false;
            }
        } else {
            blResult = false;
            throw new FilloException("Recordset Closed");
        }
        return blResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void movePrevious() throws FilloException {
        if (!this.blRecordsetStatus) throw new FilloException("Recordset Closed");
        if (this.inRowNum <= 0) throw new FilloException("BOF Recordset");
        --this.inRowNum;
    }

    public void close() {
        this.blRecordsetStatus = false;
    }

    public void moveLast() throws FilloException {
        if (this.blRecordsetStatus) {
            if (((Map)this.oRecordset).size() > 1) {
                this.inRowNum = ((Map)this.oRecordset).size() - 1;
            }
        } else {
            throw new FilloException("Recordset Closed");
        }
    }

    public void moveFirst() throws FilloException {
        if (!this.blRecordsetStatus) {
            throw new FilloException("Recordset Closed");
        }
        this.inRowNum = 0;
    }

    public int getCount() throws FilloException {
        int inCount = 0;
        if (!this.blRecordsetStatus) {
            throw new FilloException("Recordset Closed");
        }
        inCount = ((Map)this.oRecordset).size();
        return inCount;
    }

    public ArrayList<String> getFieldNames() throws FilloException {
        ArrayList<String> arrColumnNames = new ArrayList<String>();
        if (this.blRecordsetStatus) {
            for (Map.Entry<String, String> entry : this.colsNamesMap.entrySet()) {
                arrColumnNames.add(entry.getValue().toString().trim());
            }
        } else {
            throw new FilloException("Recordset Closed");
        }
        return arrColumnNames;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getField(String strField) throws FilloException {
        String strResult = "";
        if (!this.blRecordsetStatus) throw new FilloException("Recordset Closed");
        if (this.inRowNum <= -1) throw new FilloException("BOF Recordset");
        Map rowMap = (Map)((Map)this.oRecordset).get("" + this.inRowNum);
        if (!rowMap.containsKey(strField.toUpperCase())) throw new FilloException(strField + " field is not found");
        return ((String)rowMap.get(strField.toUpperCase())).toString();
    }

    public Field getField(int columnIndex) throws FilloException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        if (this.blRecordsetStatus) {
            try {
                if (this.inRowNum <= -1) {
                    throw new FilloException("BOF Recordset");
                }
                Map rowMap = (Map)((Map)this.oRecordset).get("" + this.inRowNum);
                String strColumnName = rowMap.keySet().toArray()[columnIndex].toString();
                fieldMap.put("Value", rowMap.get(strColumnName));
                fieldMap.put("Column", strColumnName);
                fieldMap.put("RowIndex", "" + this.inRowNum);
                fieldMap.put("ColumnIndex", "" + columnIndex);
            }
            catch (Exception e) {
                throw new FilloException("Field is not found");
            }
        } else {
            throw new FilloException("Recordset Closed");
        }
        return new Field(fieldMap);
    }

    public Recordset where(String strCondition) throws FilloException {
        Object oFilteredRecordset = null;
        String strQuery = "Select * from \"" + this.strTableName + "\" where " + strCondition.trim();
        Select select = new Select(this.strTableName, strQuery, this.colsNamesMap, this.oRecordset);
        oFilteredRecordset = select.getRecordsetForCondition();
        return new Recordset(oFilteredRecordset);
    }

    @Deprecated
    public boolean hasNext() throws FilloException {
        boolean blResult = false;
        if (this.blRecordsetStatus) {
            if (this.inRowNum < ((Map)this.oRecordset).size() - 1) {
                blResult = true;
            }
        } else {
            throw new FilloException("Recordset Closed");
        }
        return blResult;
    }
}

