/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.Connection;
import com.codoid.products.utils.FilenameUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Fillo {
    private FileInputStream file;
    private Object oConnection;
    private String strFilePath;

    public Connection getConnection(String strDataSource) throws FilloException {
        Workbook workbook = null;
        Connection connection = null;
        try {
            this.strFilePath = strDataSource;
            this.file = new FileInputStream(new File(this.strFilePath));
            workbook = this.getWorkbook(this.file, strDataSource);
            this.oConnection = workbook;
            connection = new Connection(this.oConnection, this.file, this.strFilePath, true);
        }
        catch (FileNotFoundException e) {
            throw new FilloException("Workbook is not found - " + this.strFilePath);
        }
        return connection;
    }

    private Workbook getWorkbook(FileInputStream file, String strFilePath) throws FilloException {
        Workbook wb;
        block6: {
            wb = null;
            try {
                if (FilenameUtils.getExtension(strFilePath).equalsIgnoreCase("XLS")) {
                    wb = new HSSFWorkbook(file);
                    break block6;
                }
                if (FilenameUtils.getExtension(strFilePath).equalsIgnoreCase("XLSX")) {
                    wb = new XSSFWorkbook(file);
                    break block6;
                }
                if (FilenameUtils.getExtension(strFilePath).equalsIgnoreCase("XLSM")) {
                    wb = new XSSFWorkbook(OPCPackage.open(file));
                    break block6;
                }
                throw new FilloException("Invalid file format - " + strFilePath);
            }
            catch (IOException e) {
                throw new FilloException("Unable to connect workbook - " + strFilePath);
            }
            catch (InvalidFormatException e) {
                throw new FilloException("Unable to connect workbook - " + strFilePath);
            }
        }
        return wb;
    }
}

