/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import com.codoid.products.exception.FilloException;
import com.codoid.products.fillo.CommonExcelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class DeleteExcelUtil {
    FormulaEvaluator evaluator = null;
    private int noOfRowsAffected = 0;
    int rowStart;
    int rowEnd;
    Row firstRow = null;

    public int runUpdateQuery(String strFilePath, FileInputStream file, Object oConnection, String strQuery, String strTableName, boolean blWhereConditionApplicable, Map<String, Map<String, String>> whereConditionsMap) throws FilloException {
        boolean inRowCounter = false;
        Workbook workbook = (Workbook)oConnection;
        this.evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        Sheet sheet = workbook.getSheet(strTableName);
        if (System.getProperty("ROW") == null) {
            this.rowStart = sheet.getFirstRowNum() + 1;
            this.firstRow = sheet.getRow(sheet.getFirstRowNum());
        } else {
            this.rowStart = Integer.parseInt(System.getProperty("ROW"));
            this.firstRow = sheet.getRow(this.rowStart - 1);
        }
        this.rowEnd = sheet.getLastRowNum();
        int colStart = System.getProperty("COLUMN") == null ? 0 : Integer.parseInt(System.getProperty("COLUMN")) - 1;
        Map<String, String> columnNamesMap = CommonExcelUtil.getColumnNames(colStart, this.firstRow);
        if (columnNamesMap.size() == 0) {
            throw new FilloException("Table Header(s) is Missing");
        }
        for (int rowNum = this.rowStart; rowNum <= this.rowEnd; ++rowNum) {
            try {
                Row row = sheet.getRow(rowNum);
                int inColumnCount = columnNamesMap.size() + colStart - 1;
                LinkedHashMap rowCellMap = new LinkedHashMap();
                LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>();
                for (int inCol = colStart; inCol <= inColumnCount; ++inCol) {
                    String strColumnName = columnNamesMap.get("" + inCol).toString().toUpperCase();
                    Cell cell = row.getCell(inCol, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    if (cell == null) {
                        rowMap.put(strColumnName, "null");
                        continue;
                    }
                    String strValue = CommonExcelUtil.getCellValueAsString(cell.getCellType().ordinal(), cell);
                    rowMap.put(strColumnName, strValue);
                }
                if (blWhereConditionApplicable) {
                    if (!CommonExcelUtil.multileWhereConditions(rowMap, whereConditionsMap)) continue;
                    this.removeRow(sheet, row);
                    ++this.noOfRowsAffected;
                    continue;
                }
                this.removeRow(sheet, row);
                ++this.noOfRowsAffected;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        try {
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveWorkBook(strFilePath, workbook);
        return this.noOfRowsAffected;
    }

    public void removeRow(Sheet sheet, Row row) {
        try {
            sheet.removeRow(row);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveWorkBook(String strFilePath, Workbook workbook) throws FilloException {
        try {
            FileOutputStream out = new FileOutputStream(new File(strFilePath));
            workbook.write(out);
            out.close();
        }
        catch (Exception e) {
            this.noOfRowsAffected = 0;
            throw new FilloException("Update query cannot be proccesed, if File is already opened. File Path-" + strFilePath);
        }
    }
}

