/*
 * Decompiled with CFR 0.152.
 */
package com.codoid.products.fillo;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;

public class CommonExcelUtil {
    public static Map<String, String> getRealColumnNames(int inCol, Row row) {
        int inColCounter = 0;
        LinkedHashMap<String, String> columnNamesMap = new LinkedHashMap<String, String>();
        try {
            int inColumnCount = row.getLastCellNum() - 1;
            while (inCol <= inColumnCount) {
                String strColumnName = "COLUMN_" + inColCounter;
                Cell cell = row.getCell(inCol, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                if (cell == null) {
                    columnNamesMap.put("" + inColCounter, strColumnName);
                    ++inColCounter;
                } else {
                    strColumnName = CommonExcelUtil.getCellValueAsString(cell.getCellType().ordinal(), cell).trim();
                    columnNamesMap.put("" + inColCounter, strColumnName);
                    ++inColCounter;
                }
                ++inCol;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columnNamesMap;
    }

    public static String getCellValueAsString(int inCellType, Cell cell) {
        String strCellValue = "";
        String strFormulaResultType = "";
        try {
            if (cell != null) {
                FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                CellValue cellValue = evaluator.evaluate(cell);
                switch (cellValue.getCellType()) {
                    case STRING: {
                        try {
                            strCellValue = cell.getStringCellValue();
                        }
                        catch (IllegalStateException e) {
                            strCellValue = new DataFormatter().formatRawCellContents(cell.getNumericCellValue(), cell.getCellStyle().getDataFormat(), cell.getCellStyle().getDataFormatString());
                        }
                        break;
                    }
                    case NUMERIC: {
                        strCellValue = new DataFormatter().formatRawCellContents(cell.getNumericCellValue(), cell.getCellStyle().getDataFormat(), cell.getCellStyle().getDataFormatString());
                        break;
                    }
                    case BOOLEAN: {
                        strCellValue = "" + cell.getBooleanCellValue();
                        break;
                    }
                    case BLANK: {
                        strCellValue = "";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strCellValue;
    }

    public static Map<String, String> getColumnNames(int inCol, Row row) {
        int inColCounter = 0;
        LinkedHashMap<String, String> columnNamesMap = new LinkedHashMap<String, String>();
        int inDuplicateColumnCounter = 0;
        try {
            int inColumnCount = row.getLastCellNum() - 1;
            while (inCol <= inColumnCount) {
                String strColumnName = "COLUMN_" + inColCounter;
                Cell cell = row.getCell(inCol, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                if (cell == null) {
                    columnNamesMap.put("" + inCol, strColumnName);
                    ++inColCounter;
                } else {
                    strColumnName = CommonExcelUtil.getCellValueAsString(cell.getCellType().ordinal(), cell).toUpperCase().trim();
                    if (columnNamesMap.containsValue(strColumnName)) {
                        strColumnName = strColumnName + "_" + ++inDuplicateColumnCounter;
                    }
                    columnNamesMap.put("" + inCol, strColumnName);
                    ++inColCounter;
                }
                ++inCol;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columnNamesMap;
    }

    public static boolean isInteger(String str) {
        boolean blResult = false;
        try {
            Integer.parseInt(str);
            blResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blResult;
    }

    public static int parseInteger(String str) {
        int inResult = 0;
        try {
            inResult = Integer.parseInt(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inResult;
    }

    public static boolean isLong(String str) {
        boolean blResult = false;
        try {
            Long.parseLong(str);
            blResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blResult;
    }

    public static long parseLong(String str) {
        long inResult = 0L;
        try {
            inResult = Long.parseLong(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inResult;
    }

    public static boolean isFloat(String str) {
        boolean blResult = false;
        try {
            Float.parseFloat(str);
            blResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blResult;
    }

    public static float parseFloat(String str) {
        float inResult = 0.0f;
        try {
            inResult = Float.parseFloat(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inResult;
    }

    public static boolean isDouble(String str) {
        boolean blResult = false;
        try {
            Double.parseDouble(str);
            blResult = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blResult;
    }

    public static double parseDouble(String str) {
        double inResult = 0.0;
        try {
            inResult = Double.parseDouble(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inResult;
    }

    public static boolean whereCondition(Map<String, String> rowMap, Map<String, Object> queryMap) {
        boolean blResult = false;
        try {
            String strWhereColumn = queryMap.get("WHERE_COLUMN").toString();
            String strWhereValue = queryMap.get("WHERE_VALUE").toString();
            String strWhereOperator = queryMap.get("WHERE_OPERATOR").toString();
            String strActualValue = rowMap.get(strWhereColumn);
            if (strWhereOperator.equals("=")) {
                if (strWhereValue.equalsIgnoreCase(strActualValue)) {
                    blResult = true;
                }
            } else if (strWhereOperator.equals("<>")) {
                if (!strWhereValue.equalsIgnoreCase(strActualValue)) {
                    blResult = true;
                }
            } else if (strWhereOperator.equals("<")) {
                if (CommonExcelUtil.isInteger(strWhereValue) && CommonExcelUtil.isInteger(strActualValue)) {
                    if (CommonExcelUtil.parseInteger(strActualValue) < CommonExcelUtil.parseInteger(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isFloat(strWhereValue) && CommonExcelUtil.isFloat(strActualValue)) {
                    if (CommonExcelUtil.parseFloat(strActualValue) < CommonExcelUtil.parseFloat(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isDouble(strWhereValue) && CommonExcelUtil.isDouble(strActualValue) && CommonExcelUtil.parseDouble(strActualValue) < CommonExcelUtil.parseDouble(strWhereValue)) {
                    blResult = true;
                }
            } else if (strWhereOperator.equals(">")) {
                if (CommonExcelUtil.isInteger(strWhereValue) && CommonExcelUtil.isInteger(strActualValue)) {
                    if (CommonExcelUtil.parseInteger(strActualValue) > CommonExcelUtil.parseInteger(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isFloat(strWhereValue) && CommonExcelUtil.isFloat(strActualValue)) {
                    if (CommonExcelUtil.parseFloat(strActualValue) > CommonExcelUtil.parseFloat(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isDouble(strWhereValue) && CommonExcelUtil.isDouble(strActualValue) && CommonExcelUtil.parseDouble(strActualValue) > CommonExcelUtil.parseDouble(strWhereValue)) {
                    blResult = true;
                }
            } else if (strWhereOperator.equals("<=")) {
                if (CommonExcelUtil.isInteger(strWhereValue) && CommonExcelUtil.isInteger(strActualValue)) {
                    if (CommonExcelUtil.parseInteger(strActualValue) <= CommonExcelUtil.parseInteger(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isFloat(strWhereValue) && CommonExcelUtil.isFloat(strActualValue)) {
                    if (CommonExcelUtil.parseFloat(strActualValue) <= CommonExcelUtil.parseFloat(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isDouble(strWhereValue) && CommonExcelUtil.isDouble(strActualValue) && CommonExcelUtil.parseDouble(strActualValue) <= CommonExcelUtil.parseDouble(strWhereValue)) {
                    blResult = true;
                }
            } else if (strWhereOperator.equals(">=")) {
                if (CommonExcelUtil.isInteger(strWhereValue) && CommonExcelUtil.isInteger(strActualValue)) {
                    if (CommonExcelUtil.parseInteger(strActualValue) >= CommonExcelUtil.parseInteger(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isFloat(strWhereValue) && CommonExcelUtil.isFloat(strActualValue)) {
                    if (CommonExcelUtil.parseFloat(strActualValue) >= CommonExcelUtil.parseFloat(strWhereValue)) {
                        blResult = true;
                    }
                } else if (CommonExcelUtil.isDouble(strWhereValue) && CommonExcelUtil.isDouble(strActualValue) && CommonExcelUtil.parseDouble(strActualValue) >= CommonExcelUtil.parseDouble(strWhereValue)) {
                    blResult = true;
                }
            } else if (strWhereOperator.equalsIgnoreCase("LIKE")) {
                if (strWhereValue.startsWith("%") && strWhereValue.endsWith("%")) {
                    if (strActualValue.toLowerCase().contains(strWhereValue.toLowerCase().replace("%", ""))) {
                        blResult = true;
                    }
                } else if (strWhereValue.startsWith("%")) {
                    if (strActualValue.toLowerCase().endsWith(strWhereValue.toLowerCase().replace("%", ""))) {
                        blResult = true;
                    }
                } else if (strWhereValue.endsWith("%") && strActualValue.toLowerCase().startsWith(strWhereValue.toLowerCase().replace("%", ""))) {
                    blResult = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blResult;
    }

    public static String setCellValueAsString(Cell cell, FormulaEvaluator evaluator) {
        String strCellValue = null;
        try {
            if (cell != null) {
                switch (evaluator.evaluate(cell).getCellType()) {
                    case STRING: {
                        strCellValue = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        if (DateUtil.isCellDateFormatted(cell)) {
                            strCellValue = new DataFormatter().formatCellValue(cell, evaluator);
                            break;
                        }
                        strCellValue = new DataFormatter().formatCellValue(cell);
                        break;
                    }
                    case BOOLEAN: {
                        strCellValue = new String(new Boolean(cell.getBooleanCellValue()).toString());
                        break;
                    }
                    case BLANK: {
                        strCellValue = "";
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return strCellValue;
    }

    public static boolean updateRow(Workbook workbook, Map<String, String> updateColumnNamesAndValuesMap, Map<String, Cell> rowCellMap) {
        boolean blUpdateFlag = false;
        try {
            for (Map.Entry<String, String> entry : updateColumnNamesAndValuesMap.entrySet()) {
                String strColumnName = entry.getKey().toString();
                String strValue = entry.getValue().toString();
                if (!rowCellMap.containsKey(strColumnName)) continue;
                blUpdateFlag = true;
                CommonExcelUtil.setCellValue(rowCellMap.get(strColumnName), strValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return blUpdateFlag;
    }

    public static void setCellValue(Cell cell, String strValue) {
        block8: {
            try {
                if (NumberUtils.isCreatable(strValue)) {
                    if (NumberUtils.isDigits(strValue)) {
                        cell.setCellValue(Long.parseLong(strValue));
                    } else {
                        cell.setCellValue(Double.parseDouble(strValue));
                    }
                    break block8;
                }
                if (strValue.trim().equalsIgnoreCase("true") || strValue.trim().equalsIgnoreCase("false")) {
                    cell.setCellValue(BooleanUtils.toBoolean(strValue));
                    break block8;
                }
                cell.setCellValue(strValue);
            }
            catch (Exception e) {
                cell.setCellValue(strValue);
            }
        }
    }

    public static boolean multileWhereConditions(Map<String, String> rowMap, Map<String, Map<String, String>> whereConditionsMap) {
        boolean blResult = true;
        for (Map.Entry<String, Map<String, String>> entry : whereConditionsMap.entrySet()) {
            if (CommonExcelUtil.whereCondition(rowMap, entry.getValue())) continue;
            blResult = false;
        }
        return blResult;
    }

    public static Map<String, String> filterData(boolean isAllColumnRequired, ArrayList<String> columnNames, Map<String, String> rowMap) {
        Map<Object, Object> filteredMap = new LinkedHashMap();
        filteredMap = isAllColumnRequired ? rowMap : rowMap.entrySet().stream().filter(actualColumn -> columnNames.stream().anyMatch(expectedColumn -> ((String)actualColumn.getKey()).equalsIgnoreCase((String)expectedColumn))).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (String)p.getValue()));
        return filteredMap;
    }

    public static boolean checkDistinct(Map<String, Map<String, String>> recordsetMap, Map<String, String> rowMap) {
        boolean isDistinct = false;
        try {
            isDistinct = recordsetMap.entrySet().stream().anyMatch(row -> ((Map)row.getValue()).values().toString().equals(rowMap.values().toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isDistinct;
    }
}

