/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.types;

import com.akiban.sql.StandardException;

public final class CharacterTypeAttributes {
    private String characterSet;
    private String collation;
    private CollationDerivation collationDerivation;

    public CharacterTypeAttributes(String characterSet, String collation, CollationDerivation collationDerivation) {
        this.characterSet = characterSet;
        this.collation = collation;
        this.collationDerivation = collationDerivation;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getCollation() {
        return this.collation;
    }

    public CollationDerivation getCollationDerivation() {
        return this.collationDerivation;
    }

    public static CharacterTypeAttributes forCharacterSet(String characterSet) {
        return new CharacterTypeAttributes(characterSet, null, null);
    }

    public static CharacterTypeAttributes forCollation(CharacterTypeAttributes base, String collation) {
        String characterSet = null;
        if (base != null) {
            characterSet = base.characterSet;
        }
        return new CharacterTypeAttributes(characterSet, collation, CollationDerivation.EXPLICIT);
    }

    public static CharacterTypeAttributes mergeCollations(CharacterTypeAttributes ta1, CharacterTypeAttributes ta2) throws StandardException {
        if (ta1 == null || ta1.collationDerivation == null) {
            return ta2;
        }
        if (ta2 == null || ta2.collationDerivation == null) {
            return ta1;
        }
        if (ta1.collationDerivation == CollationDerivation.EXPLICIT) {
            if (ta2.collationDerivation == CollationDerivation.EXPLICIT && !ta1.collation.equals(ta2.collation)) {
                throw new StandardException("Incompatible collations: " + ta1 + " " + ta1.collation + " and " + ta2 + " " + ta2.collation);
            }
            return ta1;
        }
        if (ta2.collationDerivation == CollationDerivation.EXPLICIT) {
            return ta2;
        }
        if (ta1.collationDerivation == CollationDerivation.IMPLICIT && ta2.collationDerivation == CollationDerivation.IMPLICIT && ta1.collation.equals(ta2.collation)) {
            return ta1;
        }
        return new CharacterTypeAttributes(null, null, CollationDerivation.NONE);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CharacterTypeAttributes)) {
            return false;
        }
        CharacterTypeAttributes other = (CharacterTypeAttributes)o;
        return (this.characterSet == null ? other.characterSet == null : this.characterSet.equals(other.characterSet)) && (this.collation == null ? other.collation == null : this.collation.equals(other.collation));
    }

    public String toString() {
        if (this.characterSet == null && this.collation == null) {
            return "none";
        }
        StringBuilder str = new StringBuilder();
        if (this.characterSet != null) {
            str.append("CHARACTER SET ");
            str.append(this.characterSet);
        }
        if (this.collation != null) {
            if (this.characterSet != null) {
                str.append(" ");
            }
            str.append("COLLATE ");
            str.append(this.collation);
        }
        return str.toString();
    }

    public static enum CollationDerivation {
        NONE,
        IMPLICIT,
        EXPLICIT;

    }
}

