/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.FromTable;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.Visitor;

abstract class TableOperatorNode
extends FromTable {
    protected ResultSetNode leftResultSet;
    protected ResultSetNode rightResultSet;

    TableOperatorNode() {
    }

    @Override
    public void init(Object leftResultSet, Object rightResultSet, Object tableProperties) throws StandardException {
        this.init(null, tableProperties);
        this.leftResultSet = (ResultSetNode)leftResultSet;
        this.rightResultSet = (ResultSetNode)rightResultSet;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        TableOperatorNode other = (TableOperatorNode)node;
        this.leftResultSet = (ResultSetNode)this.getNodeFactory().copyNode(other.leftResultSet, this.getParserContext());
        this.rightResultSet = (ResultSetNode)this.getNodeFactory().copyNode(other.rightResultSet, this.getParserContext());
    }

    @Override
    public String toString() {
        return "nestedInParens: false\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.leftResultSet != null) {
            this.printLabel(depth, "leftResultSet: ");
            this.leftResultSet.treePrint(depth + 1);
        }
        if (this.rightResultSet != null) {
            this.printLabel(depth, "rightResultSet: ");
            this.rightResultSet.treePrint(depth + 1);
        }
    }

    public ResultSetNode getLeftResultSet() {
        return this.leftResultSet;
    }

    public ResultSetNode getRightResultSet() {
        return this.rightResultSet;
    }

    public void setLeftResultSet(ResultSetNode leftResultSet) {
        this.leftResultSet = leftResultSet;
    }

    public void setRightResultSet(ResultSetNode rightResultSet) {
        this.rightResultSet = rightResultSet;
    }

    public ResultSetNode getLeftmostResultSet() {
        if (this.leftResultSet instanceof TableOperatorNode) {
            return ((TableOperatorNode)this.leftResultSet).getLeftmostResultSet();
        }
        return this.leftResultSet;
    }

    public void setLeftmostResultSet(ResultSetNode newLeftResultSet) {
        if (this.leftResultSet instanceof TableOperatorNode) {
            ((TableOperatorNode)this.leftResultSet).setLeftmostResultSet(newLeftResultSet);
        } else {
            this.leftResultSet = newLeftResultSet;
        }
    }

    @Override
    public String getExposedName() {
        return null;
    }

    public void setNestedInParens(boolean nestedInParens) {
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.leftResultSet != null) {
            this.leftResultSet = (ResultSetNode)this.leftResultSet.accept(v);
        }
        if (this.rightResultSet != null) {
            this.rightResultSet = (ResultSetNode)this.rightResultSet.accept(v);
        }
    }
}

