/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.FromTable;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.RowResultSetNode;
import com.akiban.sql.parser.Visitor;
import java.util.ArrayList;
import java.util.List;

public class RowsResultSetNode
extends FromTable {
    private List<RowResultSetNode> rows;

    @Override
    public void init(Object firstRow) throws StandardException {
        super.init(null, this.tableProperties);
        RowResultSetNode row = (RowResultSetNode)firstRow;
        this.rows = new ArrayList<RowResultSetNode>();
        this.rows.add(row);
        this.resultColumns = (ResultColumnList)this.getNodeFactory().copyNode(row.getResultColumns(), this.getParserContext());
    }

    public List<RowResultSetNode> getRows() {
        return this.rows;
    }

    public void addRow(RowResultSetNode row) {
        this.rows.add(row);
    }

    public String statementToString() {
        return "VALUES";
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        RowsResultSetNode other = (RowsResultSetNode)node;
        this.rows = new ArrayList<RowResultSetNode>(other.rows.size());
        for (RowResultSetNode row : other.rows) {
            this.rows.add((RowResultSetNode)this.getNodeFactory().copyNode(row, this.getParserContext()));
        }
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        for (int index = 0; index < this.rows.size(); ++index) {
            RowsResultSetNode.debugPrint(RowsResultSetNode.formatNodeString("[" + index + "]:", depth));
            RowResultSetNode row = this.rows.get(index);
            row.treePrint(depth);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        int size = this.rows.size();
        for (int index = 0; index < size; ++index) {
            this.rows.set(index, (RowResultSetNode)this.rows.get(index).accept(v));
        }
    }
}

