/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.NodeFactory;
import com.akiban.sql.parser.SQLParserContext;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.Visitable;
import com.akiban.sql.parser.Visitor;
import com.akiban.sql.types.DataTypeDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public abstract class QueryTreeNode
implements Visitable {
    public static final int AUTOINCREMENT_START_INDEX = 0;
    public static final int AUTOINCREMENT_INC_INDEX = 1;
    public static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    public static final int AUTOINCREMENT_CREATE_MODIFY = 3;
    private int beginOffset = -1;
    private int endOffset = -1;
    private int nodeType;
    private SQLParserContext pc;
    private Object userData;
    private static Writer debugOutput = null;

    public void setParserContext(SQLParserContext pc) {
        this.pc = pc;
    }

    public SQLParserContext getParserContext() {
        return this.pc;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    public NodeFactory getNodeFactory() {
        return this.pc.getNodeFactory();
    }

    public void copyFrom(QueryTreeNode other) throws StandardException {
        this.userData = this.getNodeFactory().copyUserData(this, other.userData);
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    protected String nodeHeader() {
        return "\n" + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n";
    }

    public static String formatNodeString(String nodeString, int depth) {
        StringBuffer nodeStringBuffer = new StringBuffer(nodeString);
        char[] indent = new char[depth];
        while (depth > 0) {
            indent[depth - 1] = 9;
            --depth;
        }
        nodeStringBuffer.insert(0, indent);
        for (int pos = 0; pos < nodeStringBuffer.length() - 1; ++pos) {
            char c = nodeStringBuffer.charAt(pos);
            if (c != '\n') continue;
            nodeStringBuffer.insert(pos + 1, indent);
        }
        return nodeStringBuffer.toString();
    }

    public void treePrint() {
        QueryTreeNode.debugPrint(this.nodeHeader());
        String thisStr = QueryTreeNode.formatNodeString(this.toString(), 0);
        if (QueryTreeNode.containsInfo(thisStr)) {
            QueryTreeNode.debugPrint(thisStr);
        }
        this.printSubNodes(0);
        QueryTreeNode.debugFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void treePrint(Writer writer) {
        Writer oldWriter = QueryTreeNode.getDebugOutput();
        try {
            QueryTreeNode.setDebugOutput(writer);
            this.treePrint();
        }
        finally {
            QueryTreeNode.setDebugOutput(oldWriter);
        }
    }

    public void stackPrint() {
        QueryTreeNode.debugPrint("Stacktrace:\n");
        Exception e = new Exception("dummy");
        StackTraceElement[] st = e.getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            QueryTreeNode.debugPrint(st[i] + "\n");
        }
        QueryTreeNode.debugFlush();
    }

    public void treePrint(int depth) {
        Map printed = this.getParserContext().getPrintedObjectsMap();
        if (printed.containsKey(this)) {
            QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.nodeHeader(), depth));
            QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString("***truncated***\n", depth));
        } else {
            printed.put(this, null);
            QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.nodeHeader(), depth));
            String thisStr = QueryTreeNode.formatNodeString(this.toString(), depth);
            if (QueryTreeNode.containsInfo(thisStr)) {
                QueryTreeNode.debugPrint(thisStr);
            }
            if (thisStr.charAt(thisStr.length() - 1) != '\n') {
                QueryTreeNode.debugPrint("\n");
            }
            this.printSubNodes(depth);
        }
    }

    private static boolean containsInfo(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\t' || str.charAt(i) == '\n') continue;
            return true;
        }
        return false;
    }

    public static Writer getDebugOutput() {
        return debugOutput;
    }

    public static void setDebugOutput(Writer writer) {
        debugOutput = writer;
    }

    public static void debugPrint(String outputString) {
        if (debugOutput == null) {
            System.out.print(outputString);
        } else {
            try {
                debugOutput.write(outputString);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected static void debugFlush() {
        if (debugOutput != null) {
            try {
                debugOutput.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void printSubNodes(int depth) {
        if (this.userData != null) {
            this.printLabel(depth, "userData: ");
            QueryTreeNode.debugPrint(this.userData.toString() + "\n");
        }
    }

    public String toString() {
        return "";
    }

    public void printLabel(int depth, String label) {
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(label, depth));
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    protected boolean isInstanceOf(int nodeType) {
        return this.nodeType == nodeType;
    }

    @Override
    public final Visitable accept(Visitor v) throws StandardException {
        QueryTreeNode ret;
        boolean childrenFirst = v.visitChildrenFirst(this);
        boolean skipChildren = v.skipChildren(this);
        if (childrenFirst && !skipChildren && !v.stopTraversal()) {
            this.acceptChildren(v);
        }
        Visitable visitable = ret = v.stopTraversal() ? this : v.visit(this);
        if (!(childrenFirst || skipChildren || v.stopTraversal())) {
            this.acceptChildren(v);
        }
        return ret;
    }

    void acceptChildren(Visitor v) throws StandardException {
    }

    protected int getStatementType() {
        return 0;
    }

    public ConstantNode getNullNode(DataTypeDescriptor type) throws StandardException {
        int constantNodeType;
        switch (type.getTypeId().getJDBCTypeId()) {
            case 12: {
                constantNodeType = 77;
                break;
            }
            case 1: {
                constantNodeType = 61;
                break;
            }
            case -6: {
                constantNodeType = 75;
                break;
            }
            case 5: {
                constantNodeType = 74;
                break;
            }
            case 4: {
                constantNodeType = 70;
                break;
            }
            case -5: {
                constantNodeType = 71;
                break;
            }
            case 7: {
                constantNodeType = 69;
                break;
            }
            case 8: {
                constantNodeType = 68;
                break;
            }
            case 2: 
            case 3: {
                constantNodeType = 67;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                constantNodeType = 76;
                break;
            }
            case -2: {
                constantNodeType = 58;
                break;
            }
            case -3: {
                constantNodeType = 59;
                break;
            }
            case -1: {
                constantNodeType = 73;
                break;
            }
            case 2005: {
                constantNodeType = 196;
                break;
            }
            case -4: {
                constantNodeType = 72;
                break;
            }
            case 2004: {
                constantNodeType = 195;
                break;
            }
            case 2009: {
                constantNodeType = 199;
                break;
            }
            case 16: {
                constantNodeType = 38;
                break;
            }
            default: {
                if (type.getTypeId().userType()) {
                    constantNodeType = 76;
                    break;
                }
                assert (false) : "Unknown type " + type.getTypeId().getSQLTypeName() + " in getNullNode";
                return null;
            }
        }
        ConstantNode constantNode = (ConstantNode)this.getNodeFactory().getNode(constantNodeType, type.getTypeId(), this.pc);
        constantNode.setType(type.getNullabilityType(true));
        return constantNode;
    }

    public Object convertDefaultNode(DataTypeDescriptor typeDescriptor) throws StandardException {
        return null;
    }

    public void init(Object arg1) throws StandardException {
        assert (false) : "Single-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2) throws StandardException {
        assert (false) : "Two-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3) throws StandardException {
        assert (false) : "Three-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4) throws StandardException {
        assert (false) : "Four-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws StandardException {
        assert (false) : "Five-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws StandardException {
        assert (false) : "Six-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws StandardException {
        assert (false) : "Seven-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws StandardException {
        assert (false) : "Eight-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws StandardException {
        assert (false) : "Nine-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws StandardException {
        assert (false) : "Ten-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws StandardException {
        assert (false) : "Eleven-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws StandardException {
        assert (false) : "Twelve-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws StandardException {
        assert (false) : "Thirteen-argument init() not implemented for " + this.getClass().getName();
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws StandardException {
        assert (false) : "Fourteen-argument init() not implemented for " + this.getClass().getName();
    }

    public TableName makeTableName(String schemaName, String flatName) throws StandardException {
        return QueryTreeNode.makeTableName(this.getNodeFactory(), this.getParserContext(), schemaName, flatName);
    }

    public static TableName makeTableName(NodeFactory nodeFactory, SQLParserContext parserContext, String schemaName, String flatName) throws StandardException {
        return (TableName)nodeFactory.getNode(34, schemaName, flatName, parserContext);
    }
}

