/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.types.TypeId;

public class BooleanConstantNode
extends ConstantNode {
    private boolean booleanValue;
    private boolean unknownValue;

    @Override
    public void init(Object arg1) throws StandardException {
        if (arg1 == null) {
            super.init(TypeId.BOOLEAN_ID, Boolean.TRUE, 4);
            this.setValue(null);
        } else if (arg1 instanceof Boolean) {
            this.booleanValue = (Boolean)arg1;
            super.init(TypeId.BOOLEAN_ID, Boolean.FALSE, this.booleanValue ? 4 : 5);
            super.setValue(arg1);
        } else {
            super.init(arg1, Boolean.TRUE, 5);
            this.unknownValue = true;
        }
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        BooleanConstantNode other = (BooleanConstantNode)node;
        this.booleanValue = other.booleanValue;
        this.unknownValue = other.unknownValue;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    @Override
    Object getConstantValueAsObject() {
        return this.booleanValue ? Boolean.TRUE : Boolean.FALSE;
    }

    String getValueAsString() {
        if (this.booleanValue) {
            return "true";
        }
        return "false";
    }

    @Override
    public boolean isBooleanTrue() {
        return this.booleanValue && !this.unknownValue;
    }

    @Override
    public boolean isBooleanFalse() {
        return !this.booleanValue && !this.unknownValue;
    }
}

