/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.MiscellaneousStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.SetConfigurationNode;

public class AlterServerNode
extends MiscellaneousStatementNode {
    private Integer sessionID = null;
    private AlterType alterSessionType;
    private SetConfigurationNode scn = null;
    private boolean shutdownImmediate;

    @Override
    public void init(Object config) {
        if (config instanceof SetConfigurationNode) {
            this.scn = (SetConfigurationNode)config;
            this.alterSessionType = AlterType.SET_SERVER_VARIABLE;
        } else if (config instanceof Boolean) {
            this.alterSessionType = AlterType.SHUTDOWN;
            this.shutdownImmediate = (Boolean)config;
        }
    }

    @Override
    public void init(Object interrupt, Object disconnect, Object kill, Object session) {
        if (interrupt != null) {
            this.alterSessionType = AlterType.INTERRUPT_SESSION;
        } else if (disconnect != null) {
            this.alterSessionType = AlterType.DISCONNECT_SESSION;
        } else if (kill != null) {
            this.alterSessionType = AlterType.KILL_SESSION;
        }
        if (session instanceof ConstantNode) {
            this.sessionID = (Integer)((ConstantNode)session).getValue();
        }
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        AlterServerNode other = (AlterServerNode)node;
        this.sessionID = other.sessionID;
        this.alterSessionType = other.alterSessionType;
        this.scn = (SetConfigurationNode)this.getNodeFactory().copyNode(other.scn, this.getParserContext());
        this.shutdownImmediate = other.shutdownImmediate;
    }

    @Override
    public String statementToString() {
        return "ALTER SERVER";
    }

    @Override
    public String toString() {
        String ret = null;
        switch (this.alterSessionType) {
            case SET_SERVER_VARIABLE: {
                ret = this.scn.toString();
                break;
            }
            case SHUTDOWN: {
                ret = "shutdown immediate: " + this.shutdownImmediate;
                break;
            }
            case INTERRUPT_SESSION: 
            case DISCONNECT_SESSION: 
            case KILL_SESSION: {
                ret = "sessionType: " + this.alterSessionType.name() + "\n" + "sessionID: " + this.sessionID;
            }
        }
        ret = super.toString() + ret;
        return ret;
    }

    public final Integer getSessionID() {
        return this.sessionID;
    }

    public final AlterType getAlterSessionType() {
        return this.alterSessionType;
    }

    public final boolean isShutdownImmediate() {
        return this.shutdownImmediate;
    }

    public String getVariable() {
        return this.scn.getVariable();
    }

    public String getValue() {
        return this.scn.getValue();
    }

    public static enum AlterType {
        SET_SERVER_VARIABLE,
        INTERRUPT_SESSION,
        DISCONNECT_SESSION,
        KILL_SESSION,
        SHUTDOWN;

    }
}

