/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class TimeTypeCompiler
extends TypeCompiler {
    protected TimeTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLOBTypeId() && !otherType.isLongVarcharTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Time";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getTime";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 8;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator2) throws StandardException {
        boolean nullable;
        TypeId rightTypeId = rightType.getTypeId();
        boolean bl = nullable = leftType.isNullable() || rightType.isNullable();
        if (rightTypeId.isDateTimeTimeStampTypeId()) {
            if (operator2.equals("-")) {
                switch (rightTypeId.getTypeFormatId()) {
                    case 14: {
                        return new DataTypeDescriptor(TypeId.INTERVAL_HOUR_SECOND_ID, nullable);
                    }
                }
                return new DataTypeDescriptor(TypeId.INTERVAL_DAY_SECOND_ID, nullable);
            }
        } else if (rightTypeId.isIntervalTypeId() && (operator2.equals("+") || operator2.equals("-"))) {
            switch (rightTypeId.getTypeFormatId()) {
                case 25: {
                    if (rightTypeId != TypeId.INTERVAL_HOUR_ID && rightTypeId != TypeId.INTERVAL_MINUTE_ID && rightTypeId != TypeId.INTERVAL_SECOND_ID && rightTypeId != TypeId.INTERVAL_HOUR_MINUTE_ID && rightTypeId != TypeId.INTERVAL_HOUR_SECOND_ID && rightTypeId != TypeId.INTERVAL_MINUTE_SECOND_ID) break;
                    return leftType.getNullabilityType(nullable);
                }
            }
            return new DataTypeDescriptor(TypeId.TIMESTAMP_ID, nullable);
        }
        return super.resolveArithmeticOperation(leftType, rightType, operator2);
    }
}

