/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.compiler.TypeCompiler;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public final class NumericTypeCompiler
extends TypeCompiler {
    protected NumericTypeCompiler(TypeId typeId) {
        super(typeId);
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 6: {
                return "double";
            }
            case 7: {
                return "int";
            }
            case 8: {
                return "long";
            }
            case 11: {
                return "float";
            }
            case 13: {
                return "short";
            }
            case 16: {
                return "byte";
            }
        }
        assert (false) : "unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId;
        return null;
    }

    @Override
    public String getPrimitiveMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 6: {
                return "getDouble";
            }
            case 7: {
                return "getInt";
            }
            case 8: {
                return "getLong";
            }
            case 11: {
                return "getFloat";
            }
            case 13: {
                return "getShort";
            }
            case 16: {
                return "getByte";
            }
        }
        assert (false) : "unexpected formatId in getPrimitiveMethodName() - " + formatId;
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 4: {
                return dts.getPrecision() + 2;
            }
            case 6: {
                return 54;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 20;
            }
            case 11: {
                return 25;
            }
            case 13: {
                return 6;
            }
            case 16: {
                return 4;
            }
        }
        assert (false) : "unexpected formatId in getCastToCharWidth() - " + formatId;
        return 0;
    }

    @Override
    public DataTypeDescriptor resolveArithmeticOperation(DataTypeDescriptor leftType, DataTypeDescriptor rightType, String operator2) throws StandardException {
        int maximumWidth;
        NumericTypeCompiler higherTC;
        DataTypeDescriptor higherType;
        assert (leftType.getTypeId().isNumericTypeId()) : "The left type is supposed to be a number because we're resolving an arithmetic operator";
        TypeId leftTypeId = leftType.getTypeId();
        TypeId rightTypeId = rightType.getTypeId();
        boolean supported = true;
        if (!rightTypeId.isNumericTypeId()) {
            if (rightTypeId.isIntervalTypeId() && operator2.equals("*")) {
                return NumericTypeCompiler.getTypeCompiler(rightTypeId).resolveArithmeticOperation(rightType, leftType, operator2);
            }
            supported = false;
        }
        if ("mod".equals(operator2)) {
            switch (leftTypeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    supported = false;
                }
            }
            switch (rightTypeId.getJDBCTypeId()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    supported = false;
                }
            }
        }
        if (!supported) {
            return super.resolveArithmeticOperation(leftType, rightType, operator2);
        }
        if (rightTypeId.typePrecedence() > leftTypeId.typePrecedence()) {
            higherType = rightType;
            higherTC = (NumericTypeCompiler)NumericTypeCompiler.getTypeCompiler(rightTypeId);
        } else {
            higherType = leftType;
            higherTC = (NumericTypeCompiler)NumericTypeCompiler.getTypeCompiler(leftTypeId);
        }
        int precision = higherTC.getPrecision(operator2, leftType, rightType);
        int scale = higherTC.getScale(operator2, leftType, rightType);
        if (higherType.getTypeId().isDecimalTypeId()) {
            int n = maximumWidth = scale > 0 ? precision + 3 : precision + 1;
            if (maximumWidth < precision) {
                maximumWidth = Integer.MAX_VALUE;
            }
        } else {
            maximumWidth = higherType.getMaximumWidth();
        }
        boolean nullable = leftType.isNullable() || rightType.isNullable();
        return new DataTypeDescriptor(higherType.getTypeId(), precision, scale, nullable, maximumWidth);
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return this.numberConvertible(otherType, forDataTypeFunction);
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return otherType.isNumericTypeId();
    }

    private int getPrecision(String operator2, DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        long val;
        if (this.getStoredFormatIdFromTypeId() != 4) {
            return leftType.getPrecision();
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        if (operator2 == null) {
            val = (long)this.getScale(operator2, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale);
        } else if (operator2.equals("*")) {
            val = lprec + rprec;
        } else if (operator2.equals("sum")) {
            val = lprec - lscale + rprec - rscale + (long)this.getScale(operator2, leftType, rightType);
        } else if (operator2.equals("/")) {
            val = Math.min(31L, (long)this.getScale(operator2, leftType, rightType) + lprec - lscale + rprec);
        } else {
            val = (long)this.getScale(operator2, leftType, rightType) + Math.max(lprec - lscale, rprec - rscale) + 1L;
            if (val > 31L) {
                val = 31L;
            }
        }
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        val = Math.min(31L, val);
        return (int)val;
    }

    private int getScale(String operator2, DataTypeDescriptor leftType, DataTypeDescriptor rightType) {
        if (this.getStoredFormatIdFromTypeId() != 4) {
            return leftType.getScale();
        }
        long lscale = leftType.getScale();
        long rscale = rightType.getScale();
        long lprec = leftType.getPrecision();
        long rprec = rightType.getPrecision();
        long val = "*".equals(operator2) ? lscale + rscale : ("/".equals(operator2) ? Math.max(31L - lprec + lscale - rscale, 0L) : ("avg".equals(operator2) ? Math.max(Math.max(lscale, rscale), 31L) : Math.max(lscale, rscale)));
        if (val > Integer.MAX_VALUE) {
            val = Integer.MAX_VALUE;
        }
        val = Math.min(31L, val);
        return (int)val;
    }
}

