/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.compiler;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.AndNode;
import com.akiban.sql.parser.BetweenOperatorNode;
import com.akiban.sql.parser.BinaryComparisonOperatorNode;
import com.akiban.sql.parser.BinaryLogicalOperatorNode;
import com.akiban.sql.parser.BinaryOperatorNode;
import com.akiban.sql.parser.BooleanConstantNode;
import com.akiban.sql.parser.ConditionalNode;
import com.akiban.sql.parser.ConstantNode;
import com.akiban.sql.parser.InListOperatorNode;
import com.akiban.sql.parser.IsNode;
import com.akiban.sql.parser.JoinNode;
import com.akiban.sql.parser.NodeFactory;
import com.akiban.sql.parser.NotNode;
import com.akiban.sql.parser.OrNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.RowConstructorNode;
import com.akiban.sql.parser.SQLParserContext;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.SubqueryNode;
import com.akiban.sql.parser.UnaryOperatorNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.parser.Visitable;
import com.akiban.sql.parser.Visitor;
import com.akiban.sql.types.DataTypeDescriptor;
import com.akiban.sql.types.TypeId;

public class BooleanNormalizer
implements Visitor {
    public static final int NOT_IN_AND_LIMIT = 100;
    SQLParserContext parserContext;
    NodeFactory nodeFactory;

    public BooleanNormalizer(SQLParserContext parserContext) {
        this.parserContext = parserContext;
        this.nodeFactory = parserContext.getNodeFactory();
    }

    public StatementNode normalize(StatementNode stmt) throws StandardException {
        return (StatementNode)stmt.accept(this);
    }

    public void selectNode(SelectNode node) throws StandardException {
        node.setWhereClause(this.normalizeExpression(node.getWhereClause()));
        node.setHavingClause(this.normalizeExpression(node.getHavingClause()));
    }

    public void joinNode(JoinNode node) throws StandardException {
        node.setJoinClause(this.normalizeExpression(node.getJoinClause()));
    }

    public void conditionalNode(ConditionalNode node) throws StandardException {
        node.setTestCondition(this.normalizeExpression(node.getTestCondition()));
    }

    public ValueNode normalizeExpression(ValueNode boolClause) throws StandardException {
        if (boolClause != null) {
            boolClause = this.eliminateNots(boolClause, false);
            assert (this.verifyEliminateNots(boolClause));
            boolClause = this.putAndsOnTop(boolClause);
            assert (this.verifyPutAndsOnTop(boolClause));
            boolClause = this.changeToCNF(boolClause, true);
            assert (this.verifyChangeToCNF(boolClause, true));
        }
        return boolClause;
    }

    protected ValueNode eliminateNots(ValueNode node, boolean underNotNode) throws StandardException {
        switch (node.getNodeType()) {
            case 26: {
                NotNode notNode = (NotNode)node;
                return this.eliminateNots(notNode.getOperand(), !underNotNode);
            }
            case 39: 
            case 52: {
                BinaryLogicalOperatorNode bnode = (BinaryLogicalOperatorNode)node;
                ValueNode leftOperand = bnode.getLeftOperand();
                ValueNode rightOperand = bnode.getRightOperand();
                leftOperand = this.eliminateNots(leftOperand, underNotNode);
                rightOperand = this.eliminateNots(rightOperand, underNotNode);
                if (underNotNode) {
                    BinaryLogicalOperatorNode cnode = (BinaryLogicalOperatorNode)this.nodeFactory.getNode(node.getNodeType() == 39 ? 52 : 39, leftOperand, rightOperand, this.parserContext);
                    cnode.setType(bnode.getType());
                    return cnode;
                }
                bnode.setLeftOperand(leftOperand);
                bnode.setRightOperand(rightOperand);
                break;
            }
            case 54: {
                ConditionalNode conditionalNode = (ConditionalNode)node;
                ValueNode thenNode = conditionalNode.getThenNode();
                ValueNode elseNode = conditionalNode.getElseNode();
                thenNode = this.eliminateNots(thenNode, false);
                elseNode = this.eliminateNots(elseNode, false);
                if (underNotNode) {
                    ValueNode swap = thenNode;
                    thenNode = elseNode;
                    elseNode = swap;
                }
                conditionalNode.setThenNode(thenNode);
                conditionalNode.setElseNode(elseNode);
                break;
            }
            case 111: {
                IsNode isNode = (IsNode)node;
                ValueNode leftOperand = isNode.getLeftOperand();
                leftOperand = this.eliminateNots(leftOperand, underNotNode);
                isNode.setLeftOperand(leftOperand);
                if (!underNotNode) break;
                isNode.toggleNegated();
                break;
            }
            case 24: 
            case 25: {
                int newNodeType;
                if (!underNotNode) break;
                UnaryOperatorNode unode = (UnaryOperatorNode)node;
                ValueNode operand = unode.getOperand();
                switch (node.getNodeType()) {
                    case 25: {
                        newNodeType = 24;
                        break;
                    }
                    case 24: {
                        newNodeType = 25;
                        break;
                    }
                    default: {
                        assert (false);
                        newNodeType = -1;
                    }
                }
                ValueNode newNode = (ValueNode)this.nodeFactory.getNode(newNodeType, operand, this.parserContext);
                newNode.setType(unode.getType());
                return newNode;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                int newNodeType;
                if (!underNotNode) break;
                BinaryOperatorNode onode = (BinaryOperatorNode)node;
                ValueNode leftOperand = onode.getLeftOperand();
                ValueNode rightOperand = onode.getRightOperand();
                switch (node.getNodeType()) {
                    case 41: {
                        newNodeType = 47;
                        break;
                    }
                    case 42: {
                        newNodeType = 45;
                        break;
                    }
                    case 43: {
                        newNodeType = 44;
                        break;
                    }
                    case 45: {
                        newNodeType = 42;
                        break;
                    }
                    case 44: {
                        newNodeType = 43;
                        break;
                    }
                    case 47: {
                        newNodeType = 41;
                        break;
                    }
                    default: {
                        assert (false);
                        newNodeType = -1;
                    }
                }
                ValueNode newNode = (ValueNode)this.nodeFactory.getNode(newNodeType, leftOperand, rightOperand, this.parserContext);
                newNode.setType(onode.getType());
                return newNode;
            }
            case 53: {
                boolean nullable;
                if (!underNotNode) break;
                BetweenOperatorNode betweenOperatorNode = (BetweenOperatorNode)node;
                ValueNode leftOperand = betweenOperatorNode.getLeftOperand();
                ValueNodeList rightOperandList = betweenOperatorNode.getRightOperandList();
                BinaryComparisonOperatorNode leftBCO = (BinaryComparisonOperatorNode)this.nodeFactory.getNode(45, leftOperand, rightOperandList.get(0), this.parserContext);
                BinaryComparisonOperatorNode rightBCO = (BinaryComparisonOperatorNode)this.nodeFactory.getNode(43, leftOperand, rightOperandList.get(1), this.parserContext);
                OrNode newOr = (OrNode)this.nodeFactory.getNode(52, leftBCO, rightBCO, this.parserContext);
                DataTypeDescriptor leftType = leftOperand.getType();
                DataTypeDescriptor right0Type = ((ValueNode)rightOperandList.get(0)).getType();
                DataTypeDescriptor right1Type = ((ValueNode)rightOperandList.get(1)).getType();
                boolean orNullable = false;
                if (leftType != null && right0Type != null) {
                    nullable = leftType.isNullable() || right0Type.isNullable();
                    DataTypeDescriptor leftBCType = new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullable);
                    leftBCO.setType(leftBCType);
                    orNullable = nullable;
                }
                if (leftType != null && right1Type != null) {
                    nullable = leftType.isNullable() || right1Type.isNullable();
                    DataTypeDescriptor rightBCType = new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullable);
                    rightBCO.setType(rightBCType);
                    orNullable |= nullable;
                }
                if (leftType != null && right0Type != null && right1Type != null) {
                    newOr.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, orNullable));
                }
                return newOr;
            }
            case 55: {
                if (!underNotNode) break;
                return this.inWithNestedTuples((InListOperatorNode)node);
            }
            case 93: {
                if (!underNotNode) break;
                SubqueryNode snode = (SubqueryNode)node;
                SubqueryNode.SubqueryType subqueryType = snode.getSubqueryType();
                switch (subqueryType) {
                    case IN: {
                        subqueryType = SubqueryNode.SubqueryType.NOT_IN;
                        break;
                    }
                    case NOT_IN: {
                        subqueryType = SubqueryNode.SubqueryType.IN;
                        break;
                    }
                    case EQ_ANY: {
                        subqueryType = SubqueryNode.SubqueryType.NE_ALL;
                        break;
                    }
                    case EQ_ALL: {
                        subqueryType = SubqueryNode.SubqueryType.NE_ANY;
                        break;
                    }
                    case NE_ANY: {
                        subqueryType = SubqueryNode.SubqueryType.EQ_ALL;
                        break;
                    }
                    case NE_ALL: {
                        subqueryType = SubqueryNode.SubqueryType.EQ_ANY;
                        break;
                    }
                    case GT_ANY: {
                        subqueryType = SubqueryNode.SubqueryType.LE_ALL;
                        break;
                    }
                    case GT_ALL: {
                        subqueryType = SubqueryNode.SubqueryType.LE_ANY;
                        break;
                    }
                    case GE_ANY: {
                        subqueryType = SubqueryNode.SubqueryType.LT_ALL;
                        break;
                    }
                    case GE_ALL: {
                        subqueryType = SubqueryNode.SubqueryType.LT_ANY;
                        break;
                    }
                    case LT_ANY: {
                        subqueryType = SubqueryNode.SubqueryType.GE_ALL;
                        break;
                    }
                    case LT_ALL: {
                        subqueryType = SubqueryNode.SubqueryType.GE_ANY;
                        break;
                    }
                    case LE_ANY: {
                        subqueryType = SubqueryNode.SubqueryType.GT_ALL;
                        break;
                    }
                    case LE_ALL: {
                        subqueryType = SubqueryNode.SubqueryType.GT_ANY;
                        break;
                    }
                    case EXISTS: {
                        subqueryType = SubqueryNode.SubqueryType.NOT_EXISTS;
                        break;
                    }
                    case NOT_EXISTS: {
                        subqueryType = SubqueryNode.SubqueryType.EXISTS;
                        break;
                    }
                    case EXPRESSION: {
                        return this.equalsBooleanConstant(node, Boolean.FALSE);
                    }
                    default: {
                        assert (false) : "NOT is not supported for this time of subquery";
                        return this.equalsBooleanConstant(node, Boolean.FALSE);
                    }
                }
                snode.setSubqueryType(subqueryType);
                break;
            }
            case 38: {
                BooleanConstantNode bnode;
                if (!underNotNode) break;
                bnode.setBooleanValue(!(bnode = (BooleanConstantNode)node).getBooleanValue());
                break;
            }
            case 31: {
                ConstantNode cnode;
                if (!underNotNode) break;
                cnode.setValue((cnode = (ConstantNode)node).getValue() == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE);
                break;
            }
            case 62: {
                return this.equalsBooleanConstant(this.castToBoolean(node), underNotNode ? Boolean.FALSE : Boolean.TRUE);
            }
            default: {
                if (underNotNode) {
                    return this.equalsBooleanConstant(this.castToBoolean(node), Boolean.FALSE);
                }
                return this.castToBoolean(node);
            }
        }
        return node;
    }

    protected ValueNode getNotEqual(ValueNode left, ValueNode right) throws StandardException {
        if (left instanceof RowConstructorNode) {
            if (right instanceof RowConstructorNode) {
                ValueNodeList leftList = ((RowConstructorNode)left).getNodeList();
                ValueNodeList rightList = ((RowConstructorNode)right).getNodeList();
                if (leftList.size() != rightList.size()) {
                    throw new IllegalArgumentException("Mismatched column count in IN's operand, left: " + leftList.size() + ", right: " + rightList.size());
                }
                ValueNode result = null;
                for (int n = 0; n < leftList.size(); ++n) {
                    ValueNode equalNode = this.getNotEqual((ValueNode)leftList.get(n), (ValueNode)rightList.get(n));
                    if (result == null) {
                        result = equalNode;
                        continue;
                    }
                    OrNode orNode = (OrNode)this.nodeFactory.getNode(52, result, equalNode, this.parserContext);
                    result = orNode;
                }
                return result;
            }
            throw new IllegalArgumentException("Mismatched column count in IN's operand");
        }
        if (right instanceof RowConstructorNode) {
            throw new IllegalArgumentException("Mismatched column count in IN's operands");
        }
        return (ValueNode)this.nodeFactory.getNode(47, left, right, this.parserContext);
    }

    protected ValueNode inWithNestedTuples(InListOperatorNode node) throws StandardException {
        RowConstructorNode rightList = node.getRightOperandList();
        if (rightList.getNodeList().size() > 100) {
            node.setNegated(true);
            return node;
        }
        RowConstructorNode leftList = node.getLeftOperand();
        ValueNode result = null;
        boolean nested = leftList.getDepth() > 0;
        ValueNode left = (ValueNode)leftList.getNodeList().get(0);
        for (ValueNode rightNode : rightList.getNodeList()) {
            ValueNode equalNode = this.getNotEqual(nested ? leftList : left, rightNode);
            if (result == null) {
                result = equalNode;
                continue;
            }
            AndNode andNode = (AndNode)this.nodeFactory.getNode(39, equalNode, result, this.parserContext);
            result = andNode;
        }
        return result;
    }

    protected ValueNode castToBoolean(ValueNode node) throws StandardException {
        if (node.getType() == null || node.getType().getTypeId().isBooleanTypeId()) {
            return node;
        }
        return (ValueNode)this.nodeFactory.getNode(60, node, new DataTypeDescriptor(TypeId.BOOLEAN_ID, node.getType().isNullable()), this.parserContext);
    }

    protected ValueNode equalsBooleanConstant(ValueNode node, Boolean constant) throws StandardException {
        BooleanConstantNode trueNode = (BooleanConstantNode)this.nodeFactory.getNode(38, constant, this.parserContext);
        BinaryComparisonOperatorNode equalsNode = (BinaryComparisonOperatorNode)this.nodeFactory.getNode(41, node, trueNode, this.parserContext);
        if (node.getType() != null) {
            boolean nullableResult = node.getType().isNullable();
            equalsNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
        }
        return equalsNode;
    }

    protected boolean verifyEliminateNots(ValueNode node) {
        switch (node.getNodeType()) {
            case 26: {
                return false;
            }
            case 39: 
            case 52: {
                BinaryLogicalOperatorNode bnode = (BinaryLogicalOperatorNode)node;
                return this.verifyEliminateNots(bnode.getLeftOperand()) && this.verifyEliminateNots(bnode.getRightOperand());
            }
        }
        return true;
    }

    protected AndNode putAndsOnTop(ValueNode node) throws StandardException {
        switch (node.getNodeType()) {
            case 39: {
                AndNode andNode = (AndNode)node;
                andNode.setRightOperand(this.putAndsOnTop(andNode.getRightOperand()));
                return andNode;
            }
        }
        BooleanConstantNode trueNode = (BooleanConstantNode)this.nodeFactory.getNode(38, Boolean.TRUE, this.parserContext);
        AndNode andNode = (AndNode)this.nodeFactory.getNode(39, node, trueNode, this.parserContext);
        if (node.getType() != null) {
            boolean nullableResult = node.getType().isNullable();
            andNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
        }
        return andNode;
    }

    protected boolean verifyPutAndsOnTop(ValueNode node) {
        do {
            if (node instanceof AndNode) continue;
            return false;
        } while (!(node = ((AndNode)node).getRightOperand()).isBooleanTrue());
        return true;
    }

    protected ValueNode changeToCNF(ValueNode node, boolean underTopAndNode) throws StandardException {
        switch (node.getNodeType()) {
            case 39: {
                AndNode andNode = (AndNode)node;
                ValueNode leftOperand = andNode.getLeftOperand();
                ValueNode rightOperand = andNode.getRightOperand();
                if (!(rightOperand instanceof AndNode) && !rightOperand.isBooleanTrue()) {
                    BooleanConstantNode trueNode = (BooleanConstantNode)this.nodeFactory.getNode(38, Boolean.TRUE, this.parserContext);
                    AndNode newRight = (AndNode)this.nodeFactory.getNode(39, rightOperand, trueNode, this.parserContext);
                    newRight.setType(rightOperand.getType());
                    rightOperand = newRight;
                }
                while (leftOperand instanceof AndNode) {
                    AndNode oldLeft = (AndNode)leftOperand;
                    ValueNode oldRight = rightOperand;
                    ValueNode newLeft = oldLeft.getLeftOperand();
                    AndNode newRight = oldLeft;
                    leftOperand = newLeft;
                    rightOperand = newRight;
                    newRight.setLeftOperand(oldLeft.getRightOperand());
                    newRight.setRightOperand(oldRight);
                }
                leftOperand = this.changeToCNF(leftOperand, underTopAndNode);
                rightOperand = this.changeToCNF(rightOperand, underTopAndNode);
                andNode.setLeftOperand(leftOperand);
                andNode.setRightOperand(rightOperand);
                break;
            }
            case 52: {
                OrNode newRight;
                BooleanConstantNode falseNode;
                OrNode orNode = (OrNode)node;
                ValueNode leftOperand = orNode.getLeftOperand();
                ValueNode rightOperand = orNode.getRightOperand();
                if (rightOperand instanceof AndNode) {
                    falseNode = (BooleanConstantNode)this.nodeFactory.getNode(38, Boolean.FALSE, this.parserContext);
                    newRight = (OrNode)this.nodeFactory.getNode(52, rightOperand, falseNode, this.parserContext);
                    newRight.setType(rightOperand.getType());
                    rightOperand = newRight;
                    orNode.setRightOperand(rightOperand);
                }
                while (rightOperand instanceof OrNode) {
                    orNode = (OrNode)orNode.getRightOperand();
                    rightOperand = orNode.getRightOperand();
                }
                if (!rightOperand.isBooleanFalse()) {
                    falseNode = (BooleanConstantNode)this.nodeFactory.getNode(38, Boolean.FALSE, this.parserContext);
                    newRight = (OrNode)this.nodeFactory.getNode(52, rightOperand, falseNode, this.parserContext);
                    newRight.setType(rightOperand.getType());
                    orNode.setRightOperand(newRight);
                }
                orNode = (OrNode)node;
                rightOperand = orNode.getRightOperand();
                while (leftOperand instanceof OrNode) {
                    OrNode oldLeft = (OrNode)leftOperand;
                    ValueNode oldRight = rightOperand;
                    ValueNode newLeft = oldLeft.getLeftOperand();
                    OrNode newRight2 = oldLeft;
                    leftOperand = newLeft;
                    rightOperand = newRight2;
                    newRight2.setLeftOperand(oldLeft.getRightOperand());
                    newRight2.setRightOperand(oldRight);
                }
                leftOperand = this.changeToCNF(leftOperand, false);
                rightOperand = this.changeToCNF(rightOperand, false);
                orNode.setLeftOperand(leftOperand);
                orNode.setRightOperand(rightOperand);
            }
        }
        return node;
    }

    protected boolean verifyChangeToCNF(ValueNode node, boolean top) {
        if (node instanceof AndNode) {
            boolean isValid;
            AndNode andNode = (AndNode)node;
            ValueNode leftOperand = andNode.getLeftOperand();
            ValueNode rightOperand = andNode.getRightOperand();
            boolean bl = isValid = rightOperand instanceof AndNode || rightOperand.isBooleanTrue();
            if (rightOperand instanceof AndNode) {
                isValid = this.verifyChangeToCNF(rightOperand, false);
            }
            isValid = leftOperand instanceof AndNode ? false : isValid && this.verifyChangeToCNF(leftOperand, false);
            return isValid;
        }
        if (top) {
            return false;
        }
        if (node instanceof OrNode) {
            boolean isValid;
            OrNode orNode = (OrNode)node;
            ValueNode leftOperand = orNode.getLeftOperand();
            ValueNode rightOperand = orNode.getRightOperand();
            boolean bl = isValid = rightOperand instanceof OrNode || rightOperand.isBooleanFalse();
            if (rightOperand instanceof OrNode) {
                isValid = this.verifyChangeToCNF(rightOperand, false);
            }
            isValid = leftOperand instanceof OrNode ? false : this.verifyChangeToCNF(leftOperand, false);
            return isValid;
        }
        return true;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        switch (((QueryTreeNode)node).getNodeType()) {
            case 129: {
                this.selectNode((SelectNode)node);
                break;
            }
            case 139: 
            case 144: {
                this.joinNode((JoinNode)node);
                break;
            }
            case 54: {
                this.conditionalNode((ConditionalNode)node);
            }
        }
        return node;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return true;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }
}

