/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.logevents.SimpleReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;
import org.testng.internal.ConstructorOrMethod;

@ParametersAreNonnullByDefault
public class TextReport
implements IInvokedMethodListener {
    protected SimpleReport report = new SimpleReport();
    public static boolean onFailedTest = true;
    public static boolean onSucceededTest = true;

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if ((onFailedTest || onSucceededTest) && this.isClassAnnotatedWithReport(method)) {
            this.report.start();
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if ((testResult.isSuccess() && onSucceededTest || !testResult.isSuccess() && onFailedTest) && this.isClassAnnotatedWithReport(method)) {
            this.report.finish(testResult.getName());
        }
        this.report.clean();
    }

    private boolean isClassAnnotatedWithReport(IInvokedMethod method) {
        ConstructorOrMethod consOrMethod = method.getTestMethod().getConstructorOrMethod();
        Class testClass = consOrMethod.getDeclaringClass();
        return this.isClassAnnotatedWithReport(testClass);
    }

    boolean isClassAnnotatedWithReport(@Nullable Class<?> testClass) {
        if (testClass == null) {
            return false;
        }
        return this.getListeners(testClass).stream().anyMatch(this::isTextReportListener) || this.isClassAnnotatedWithReport(testClass.getSuperclass());
    }

    private List<Class<? extends ITestNGListener>> getListeners(Class<?> testClass) {
        Listeners annotation = testClass.getAnnotation(Listeners.class);
        return annotation != null ? Arrays.asList(annotation.value()) : Collections.emptyList();
    }

    private boolean isTextReportListener(Class<? extends ITestNGListener> listener) {
        return TextReport.class.isAssignableFrom(listener);
    }
}

