/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseCityHash;
import com.clickhouse.client.internal.jpountz.lz4.LZ4Factory;
import com.clickhouse.client.internal.jpountz.lz4.LZ4FastDecompressor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ClickHouseLZ4InputStream
extends ClickHouseInputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static final byte MAGIC = -126;
    static final int HEADER_LENGTH = 25;
    private final LZ4FastDecompressor decompressor = factory.fastDecompressor();
    private final InputStream stream;
    private final byte[] header;
    private byte[] currentBlock;
    private int position;
    private boolean closed;

    private boolean checkNext() throws IOException {
        if (!this.closed && this.position >= this.currentBlock.length) {
            this.currentBlock = this.readNextBlock();
        }
        return this.currentBlock.length > 0;
    }

    private byte[] readNextBlock() throws IOException {
        this.position = 0;
        if (!this.readFully(this.header, 0, 25)) {
            return EMPTY_BYTES;
        }
        if (this.header[16] != -126) {
            throw new IOException(ClickHouseUtils.format("Magic is not correct - expect [%d] but got [%d]", (byte)-126, this.header[16]));
        }
        int compressedSizeWithHeader = BinaryStreamUtils.toInt32(this.header, 17);
        int uncompressedSize = BinaryStreamUtils.toInt32(this.header, 21);
        int offset = 9;
        byte[] block = new byte[compressedSizeWithHeader];
        block[0] = this.header[16];
        BinaryStreamUtils.setInt32(block, 1, compressedSizeWithHeader);
        BinaryStreamUtils.setInt32(block, 5, uncompressedSize);
        if (!this.readFully(block, offset, compressedSizeWithHeader - offset)) {
            throw new EOFException();
        }
        long[] real = ClickHouseCityHash.cityHash128(block, 0, block.length);
        if (real[0] != BinaryStreamUtils.toInt64(this.header, 0) || real[1] != BinaryStreamUtils.toInt64(this.header, 8)) {
            throw new IllegalArgumentException("Checksum doesn't match: corrupted data.");
        }
        byte[] decompressed = new byte[uncompressedSize];
        this.decompressor.decompress(block, offset, decompressed, 0, uncompressedSize);
        return decompressed;
    }

    private boolean readFully(byte[] b, int off, int len) throws IOException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            if (n == 0) {
                return false;
            }
            throw new EOFException();
        }
        return true;
    }

    public ClickHouseLZ4InputStream(InputStream stream) {
        this.stream = ClickHouseChecker.nonNull(stream, "InputStream");
        this.header = new byte[25];
        this.currentBlock = EMPTY_BYTES;
        this.position = 0;
        this.closed = false;
    }

    @Override
    public byte readByte() throws IOException {
        if (!this.checkNext()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EOFException();
        }
        return this.currentBlock[this.position++];
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int estimated = this.currentBlock.length - this.position;
        if (estimated == 0 && this.checkNext()) {
            estimated = this.currentBlock.length - this.position;
        }
        return estimated;
    }

    @Override
    public int read() throws IOException {
        return this.checkNext() ? 0xFF & this.currentBlock[this.position++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copied;
        int toCopy;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.checkNext()) {
            return -1;
        }
        for (copied = 0; copied != len; copied += toCopy) {
            toCopy = Math.min(this.currentBlock.length - this.position, len - copied);
            System.arraycopy(this.currentBlock, this.position, b, off, toCopy);
            this.position += toCopy;
            off += toCopy;
            if (this.checkNext()) continue;
            break;
        }
        return copied;
    }

    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public String readString(int byteLength, Charset charset) throws IOException {
        if (byteLength < 1) {
            return "";
        }
        if (!this.checkNext()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EOFException();
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        if (this.currentBlock.length - this.position > byteLength) {
            int offset = this.position;
            this.position += byteLength;
            return new String(this.currentBlock, offset, byteLength, charset);
        }
        return new String(this.readBytes(byteLength), charset);
    }
}

