/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class MathUtilities {
    private MathUtilities() {
    }

    public static long minimum(long ... values) {
        int len = values.length;
        long current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values[i], current);
        }
        return current;
    }

    public static long maximum(long ... values) {
        int len = values.length;
        long current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values[i], current);
        }
        return current;
    }

    public static double minimum(double ... values) {
        int len = values.length;
        double current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values[i], current);
        }
        return current;
    }

    public static double maximum(double ... values) {
        int len = values.length;
        double current = values[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values[i], current);
        }
        return current;
    }

    public static BigInteger minimum(BigInteger ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to minimum()");
            }
            return values[0];
        }
        BigInteger current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to minimum()");
            }
            current = values[i].min(current);
        }
        return current;
    }

    public static BigInteger maximum(BigInteger ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to maximum()");
            }
            return values[0];
        }
        BigInteger current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to maximum()");
            }
            current = values[i].max(current);
        }
        return current;
    }

    public static BigDecimal minimum(BigDecimal ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigDecimal entry to minimum()");
            }
            return values[0];
        }
        BigDecimal current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigDecimal entry to minimum()");
            }
            current = values[i].min(current);
        }
        return current;
    }

    public static BigDecimal maximum(BigDecimal ... values) {
        int len = values.length;
        if (len == 1) {
            if (values[0] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            return values[0];
        }
        BigDecimal current = values[0];
        for (int i = 1; i < len; ++i) {
            if (values[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            current = values[i].max(current);
        }
        return current;
    }
}

