/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetAddressUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(InetAddressUtilities.class);

    private InetAddressUtilities() {
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }

    public static byte[] getIpAddress() {
        try {
            return InetAddressUtilities.getLocalHost().getAddress();
        }
        catch (Exception e) {
            LOG.warn("Failed to obtain computer's IP address", (Throwable)e);
            return new byte[]{0, 0, 0, 0};
        }
    }

    public static String getHostName() {
        try {
            return InetAddressUtilities.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.warn("Unable to fetch 'hostname'", (Throwable)e);
            return "localhost";
        }
    }
}

