/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import com.cedarsoft.exceptions.StillContainedException;
import com.cedarsoft.file.Extension;
import com.cedarsoft.file.FileName;
import com.cedarsoft.file.FileType;
import com.cedarsoft.registry.DefaultRegistry;
import com.cedarsoft.registry.Registry;
import com.cedarsoft.registry.RegistryFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileTypeRegistry
extends DefaultRegistry<FileType> {
    @Nonnull
    public static final FileType LIGHT_ZONE = new FileType("LightZone", "application/lightzone", true, new Extension("_", "lzn.jpg"));
    @Nonnull
    public static final FileType JPEG = new FileType("JPEG", "image/jpeg", false, new Extension(".", "jpg"), new Extension(".", "jpeg"));
    @Nonnull
    public static final FileType TIFF = new FileType("TIFF", "image/tiff", false, new Extension(".", "tif"), new Extension(".", "tiff"));
    @Nonnull
    public static final FileType GIMP = new FileType("Gimp", "image/xcf", false, new Extension(".", "xcf"));
    @Nonnull
    public static final FileType PHOTO_SHOP = new FileType("Photoshop", "image/psd", false, new Extension(".", "psd"));
    @Nonnull
    public static final FileType RAW_CANON = new FileType("CanonRaw", "image/cr2", false, new Extension(".", "cr2"));
    @Nonnull
    private static final List<FileType> DEFAULT = Arrays.asList(LIGHT_ZONE, JPEG, TIFF, GIMP, RAW_CANON, PHOTO_SHOP);

    @Deprecated
    public FileTypeRegistry() {
        this(true);
    }

    @Deprecated
    public FileTypeRegistry(boolean registerDefaultTypes) {
        if (registerDefaultTypes) {
            this.ensureDefaultTypesRegistered();
        }
    }

    public FileTypeRegistry(@Nonnull Collection<? extends FileType> storedObjects, @Nullable Comparator<FileType> fileTypeComparator) throws StillContainedException {
        super(storedObjects, fileTypeComparator);
    }

    @Nonnull
    public List<? extends FileType> getFileTypes() {
        return this.getStoredObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureDefaultTypesRegistered() {
        this.lock.writeLock().lock();
        try {
            if (!this.getStoredObjects().isEmpty()) {
                return;
            }
            for (FileType fileType : DEFAULT) {
                try {
                    this.store(fileType);
                }
                catch (StillContainedException stillContainedException) {}
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Nonnull
    public FileType valueOf(final @Nonnull String id) {
        return (FileType)this.findStoredObject((Registry.Matcher)new Registry.Matcher<FileType>(){

            public boolean matches(@Nonnull FileType object) {
                return object.getId().equals(id);
            }
        }, "No FileType found for <" + id + '>');
    }

    @Nonnull
    public FileType get(final @Nonnull FileName fileName) {
        return (FileType)this.findStoredObject((Registry.Matcher)new Registry.Matcher<FileType>(){

            public boolean matches(@Nonnull FileType object) {
                return object.matches(fileName);
            }
        }, "No FileType found for file <" + fileName + '>');
    }

    @Nonnull
    public FileType get(final @Nonnull String fileName) {
        return (FileType)this.findStoredObject((Registry.Matcher)new Registry.Matcher<FileType>(){

            public boolean matches(@Nonnull FileType object) {
                return object.matches(fileName);
            }
        }, "No FileType found for file <" + fileName + '>');
    }

    @Nonnull
    public FileName parseFileName(@Nonnull String fileName) {
        FileType type = this.get(fileName);
        return type.getFileName(fileName);
    }

    public static class Factory
    implements RegistryFactory<FileType, FileTypeRegistry> {
        @Nonnull
        public FileTypeRegistry createRegistry(@Nonnull List<? extends FileType> objects, @Nonnull Comparator<FileType> comparator) {
            return new FileTypeRegistry(objects, comparator);
        }
    }
}

