/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import com.cedarsoft.file.Extension;
import com.cedarsoft.file.FileName;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

public class FileType {
    @Nonnull
    private final List<Extension> extensions = new ArrayList<Extension>();
    @Nonnull
    private final String id;
    private final boolean dependentType;
    @Nonnull
    private final String contentType;

    public FileType(@Nonnull String id, @Nonnull String contentType, boolean dependentType, Extension ... extensions) {
        this(id, contentType, dependentType, Arrays.asList(extensions));
    }

    public FileType(@Nonnull String id, @Nonnull String contentType, boolean dependentType, @Nonnull Collection<? extends Extension> extensions) {
        this.contentType = contentType;
        this.dependentType = dependentType;
        if (extensions.isEmpty()) {
            throw new IllegalArgumentException("Need at least one extension");
        }
        this.id = id;
        this.extensions.addAll(extensions);
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Nonnull
    public List<? extends Extension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public boolean matches(@Nonnull String fileName) {
        for (Extension ex : this.extensions) {
            if (!fileName.toLowerCase(Locale.US).endsWith(ex.getCombined())) continue;
            return true;
        }
        return false;
    }

    public boolean matches(@Nonnull FileName fileName) {
        return this.matches(fileName.getName());
    }

    @Nonnull
    public Extension getDefaultExtension() {
        return this.extensions.get(0);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public boolean isDependentType() {
        return this.dependentType;
    }

    @Nonnull
    public FileName getFileName(@Nonnull File file) {
        return this.getFileName(file.getName());
    }

    @Nonnull
    public FileName getFileName(@Nonnull String fileName) throws IllegalArgumentException {
        String bestBase = null;
        Extension bestExtension = null;
        for (Extension extension : this.extensions) {
            int index = fileName.toLowerCase().indexOf(extension.getCombined());
            if (index < 0) continue;
            String base = fileName.substring(0, index);
            if (bestBase != null && base.length() >= bestBase.length()) continue;
            bestBase = base;
            bestExtension = extension.createCaseSensitiveExtension(fileName);
        }
        if (bestBase == null) {
            throw new IllegalArgumentException("Cannot get base for " + fileName);
        }
        return new FileName(bestBase, bestExtension);
    }

    @Nonnull
    public Extension getExtension(@Nonnull String fileName) {
        return this.getFileName(fileName).getExtension();
    }

    @Nonnull
    public String getBaseName(@Nonnull String fileName) {
        return this.getFileName(fileName).getBaseName().getName();
    }

    public String toString() {
        return "FileType{id='" + this.id + '\'' + '}';
    }

    public boolean isDefaultExtension(@Nonnull Extension extension) {
        return this.getDefaultExtension().equals(extension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileType)) {
            return false;
        }
        FileType fileType = (FileType)o;
        return this.id.equals(fileType.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

