/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import com.cedarsoft.file.BaseNameAwareFileNames;
import com.cedarsoft.file.FileName;
import com.cedarsoft.file.FileNames;
import com.cedarsoft.file.FileTypeRegistry;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.io.filefilter.FileFileFilter;

public class FileNamesFactory {
    @Nonnull
    private final FileTypeRegistry fileTypeRegistry;

    @Inject
    public FileNamesFactory(@Nonnull FileTypeRegistry fileTypeRegistry) {
        this.fileTypeRegistry = fileTypeRegistry;
    }

    @Nonnull
    public FileNames create(@Nonnull File baseDir) {
        File[] files = this.listFiles(baseDir);
        return this.create(files);
    }

    @Nonnull
    public FileNames create(@Nonnull File[] sourceFiles) {
        return this.create(Arrays.asList(sourceFiles));
    }

    public FileNames create(@Nonnull Iterable<? extends File> sourceFiles) {
        FileNames fileNames = new FileNames();
        for (File file : sourceFiles) {
            FileName fileName = this.fileTypeRegistry.parseFileName(file.getName());
            fileNames.add(fileName);
        }
        return fileNames;
    }

    @Nonnull
    public BaseNameAwareFileNames createBaseNameAware(@Nonnull File baseDir) {
        return this.createBaseNameAware(this.listFiles(baseDir));
    }

    @Nonnull
    public BaseNameAwareFileNames createBaseNameAware(@Nonnull File[] sourceFiles) {
        return this.createBaseNameAware(Arrays.asList(sourceFiles));
    }

    @Nonnull
    public BaseNameAwareFileNames createBaseNameAware(@Nonnull Iterable<? extends File> sourceFiles) {
        BaseNameAwareFileNames report = new BaseNameAwareFileNames();
        for (File file : sourceFiles) {
            FileName fileName = this.fileTypeRegistry.parseFileName(file.getName());
            report.add(fileName);
        }
        return report;
    }

    @Nonnull
    private File[] listFiles(@Nonnull File baseDir) {
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid base dir <" + baseDir.getAbsolutePath() + '>');
        }
        return baseDir.listFiles((FileFilter)FileFileFilter.FILE);
    }
}

