/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import com.cedarsoft.file.BaseName;
import com.cedarsoft.file.Extension;
import java.io.File;
import javax.annotation.Nonnull;

public class FileName {
    @Nonnull
    private final BaseName baseName;
    @Nonnull
    private final Extension extension;

    public FileName(@Nonnull String baseName, @Nonnull String extension) {
        this(new BaseName(baseName), new Extension(extension));
    }

    public FileName(@Nonnull String baseName, @Nonnull Extension extension) {
        this(new BaseName(baseName), extension);
    }

    public FileName(@Nonnull String baseName, @Nonnull String delimiter, @Nonnull String extension) {
        this(new BaseName(baseName), new Extension(delimiter, extension));
    }

    public FileName(@Nonnull BaseName baseName, @Nonnull String delimiter, @Nonnull String extension) {
        this(baseName, new Extension(delimiter, extension));
    }

    public FileName(@Nonnull BaseName baseName, @Nonnull Extension extension) {
        this.baseName = baseName;
        this.extension = extension;
    }

    @Nonnull
    public BaseName getBaseName() {
        return this.baseName;
    }

    @Nonnull
    public Extension getExtension() {
        return this.extension;
    }

    @Nonnull
    public String getName() {
        return this.baseName + this.extension.getCombined();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileName)) {
            return false;
        }
        FileName fileName = (FileName)o;
        if (!this.baseName.equals(fileName.baseName)) {
            return false;
        }
        return this.extension.equals(fileName.extension);
    }

    public int hashCode() {
        int result = this.baseName.hashCode();
        result = 31 * result + this.extension.hashCode();
        return result;
    }

    public String toString() {
        return this.baseName.toString() + this.extension.toString();
    }

    @Nonnull
    public File getFile(@Nonnull File baseDir) {
        assert (baseDir.isDirectory());
        return new File(baseDir, this.getName());
    }
}

