/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.annotation.Nonnull;

public class FileCopyManager {
    private FileCopyManager() {
    }

    public static void deleteForced(@Nonnull File toDelete) {
        if (!toDelete.exists()) {
            throw new IllegalArgumentException("File must exist: " + toDelete.getAbsolutePath());
        }
        if (toDelete.isDirectory()) {
            for (String entry : toDelete.list()) {
                File child = new File(toDelete, entry);
                FileCopyManager.deleteForced(child);
            }
        }
        toDelete.delete();
    }

    public static void copy(@Nonnull File src, @Nonnull File dest) throws IOException {
        if (src.isDirectory()) {
            FileCopyManager.copyDirectory(src, dest);
        } else {
            FileCopyManager.copyFile(src, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(@Nonnull File source, @Nonnull File target) throws IOException {
        AbstractInterruptibleChannel sourceChannel = null;
        AbstractInterruptibleChannel targetChannel = null;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            sourceChannel = in.getChannel();
            out = new FileOutputStream(target);
            targetChannel = out.getChannel();
            ((FileChannel)sourceChannel).transferTo(0L, ((FileChannel)sourceChannel).size(), (WritableByteChannel)((Object)targetChannel));
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (targetChannel != null) {
                targetChannel.close();
            }
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyDirectory(@Nonnull File srcDir, @Nonnull File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        for (String entry : srcDir.list()) {
            File src = new File(srcDir, entry);
            File dest = new File(destDir, entry);
            FileCopyManager.copy(src, dest);
        }
    }
}

