/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.file;

import java.util.Locale;
import javax.annotation.Nonnull;

public class Extension {
    @Nonnull
    public static final String DEFAULT_DELIMITER = ".";
    @Nonnull
    public static final Extension NONE = new Extension("", "");
    @Nonnull
    private final String delimiter;
    @Nonnull
    private final String extension;

    public Extension(@Nonnull String extension) {
        this(DEFAULT_DELIMITER, extension);
    }

    public Extension(@Nonnull String delimiter, @Nonnull String extension) {
        this.delimiter = delimiter;
        this.extension = extension;
    }

    @Nonnull
    public String getDelimiter() {
        return this.delimiter;
    }

    @Nonnull
    public String getExtension() {
        return this.extension;
    }

    @Nonnull
    public String getCombined() {
        return this.delimiter + this.extension;
    }

    @Nonnull
    public Extension createCaseSensitiveExtension(@Nonnull String fileName) {
        int extensionIndex = fileName.toLowerCase(Locale.US).lastIndexOf(this.getExtension().toLowerCase(Locale.US));
        return new Extension(this.getDelimiter(), fileName.substring(extensionIndex));
    }

    public String toString() {
        return this.getCombined();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension extension1 = (Extension)o;
        if (!this.delimiter.equals(extension1.delimiter)) {
            return false;
        }
        return this.extension.equalsIgnoreCase(extension1.extension);
    }

    public int hashCode() {
        int result = this.delimiter.hashCode();
        result = 31 * result + this.extension.toLowerCase(Locale.US).hashCode();
        return result;
    }
}

